/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.Tomcat7xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat8x9xConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.internal.Tomcat8x9xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;
import org.codehaus.cargo.util.XmlReplacement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Tomcat8xStandaloneLocalConfiguration
extends Tomcat7xStandaloneLocalConfiguration {
    protected static final String DIR_RESOURCE_SET = "org.apache.catalina.webresources.DirResourceSet";
    protected static final String JAR_RESOURCE_SET = "org.apache.catalina.webresources.JarResourceSet";
    protected static final String FILE_RESOURCE_SET = "org.apache.catalina.webresources.FileResourceSet";
    private static final ConfigurationCapability CAPABILITY = new Tomcat8x9xStandaloneLocalConfigurationCapability();

    public Tomcat8xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.tomcat.uriencoding", StandardCharsets.UTF_8.name());
        this.setProperty("cargo.tomcat.context.mapJarToWebinfClasses", "false");
        this.configurationBuilder = new Tomcat8x9xConfigurationBuilder();
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    protected String getExtraClasspathToken(WAR deployable) {
        String[] extraClasspath = TomcatUtils.getExtraClasspath(deployable);
        StringBuilder sb = new StringBuilder();
        sb.append("<Resources>");
        if (extraClasspath != null) {
            for (String path : extraClasspath) {
                sb.append("<PostResources ");
                this.writePostResource(path, sb);
                sb.append("\" />");
            }
        }
        sb.append("</Resources>");
        return sb.toString();
    }

    @Override
    protected void configureExtraClasspathToken(WAR deployable, Element context) {
        String[] extraClasspath = TomcatUtils.getExtraClasspath(deployable);
        if (extraClasspath != null) {
            Element resources;
            NodeList resourcesList = context.getElementsByTagName("Resources");
            if (resourcesList.getLength() > 0) {
                resources = (Element)resourcesList.item(0);
            } else {
                resources = context.getOwnerDocument().createElement("Resources");
                context.appendChild(resources);
            }
            for (String path : extraClasspath) {
                Element postResource = resources.getOwnerDocument().createElement("PostResources");
                resources.appendChild(postResource);
                this.writePostResource(path, postResource);
            }
        }
    }

    private void writePostResource(String path, StringBuilder sb) {
        if (this.getFileHandler().isDirectory(path)) {
            this.writeDirectoryPostResource(sb, path);
        } else if (path.toLowerCase().endsWith(".jar")) {
            this.writeJarPostResource(sb, path);
        } else {
            this.writeFilePostResource(sb, path);
        }
    }

    private void writePostResource(String path, Element postResourceEl) {
        if (this.getFileHandler().isDirectory(path)) {
            this.writeDirectoryPostResource(postResourceEl, path);
        } else if (path.toLowerCase().endsWith(".jar")) {
            this.writeJarPostResource(postResourceEl, path);
        } else {
            this.writeFilePostResource(postResourceEl, path);
        }
    }

    private void writeDirectoryPostResource(StringBuilder sb, String path) {
        sb.append("className=\"org.apache.catalina.webresources.DirResourceSet\" base=\"");
        sb.append(path.replace("&", "&amp;"));
        sb.append("\" webAppMount=\"/WEB-INF/classes");
    }

    private void writeDirectoryPostResource(Element postResourceEl, String path) {
        postResourceEl.setAttribute("className", DIR_RESOURCE_SET);
        postResourceEl.setAttribute("base", path.replace("&", "&amp;"));
        postResourceEl.setAttribute("webAppMount", "/WEB-INF/classes");
    }

    private void writeJarPostResource(StringBuilder sb, String path) {
        if (Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.context.mapJarToWebinfClasses"))) {
            sb.append("className=\"org.apache.catalina.webresources.JarResourceSet\" base=\"");
            sb.append(path.replace("&", "&amp;"));
            sb.append("\" webAppMount=\"/WEB-INF/classes/");
        } else {
            sb.append("className=\"org.apache.catalina.webresources.FileResourceSet\" base=\"");
            sb.append(path.replace("&", "&amp;"));
            sb.append("\" webAppMount=\"/WEB-INF/lib/");
            sb.append(this.getFileHandler().getName(path).replace("&", "&amp;"));
        }
    }

    private void writeJarPostResource(Element postResourceEl, String path) {
        if (Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.context.mapJarToWebinfClasses"))) {
            postResourceEl.setAttribute("className", JAR_RESOURCE_SET);
            postResourceEl.setAttribute("base", path.replace("&", "&amp;"));
            postResourceEl.setAttribute("webAppMount", "/WEB-INF/classes/");
        } else {
            postResourceEl.setAttribute("className", FILE_RESOURCE_SET);
            postResourceEl.setAttribute("base", path.replace("&", "&amp;"));
            postResourceEl.setAttribute("webAppMount", "/WEB-INF/lib/" + this.getFileHandler().getName(path).replace("&", "&amp;"));
        }
    }

    private void writeFilePostResource(StringBuilder sb, String path) {
        sb.append("className=\"org.apache.catalina.webresources.DirResourceSet\" base=\"");
        sb.append(this.getFileHandler().getParent(path).replace("&", "&amp;"));
        sb.append("\" internalPath=\"");
        sb.append(this.getFileHandler().getName(path).replace("&", "&amp;"));
        sb.append("\" webAppMount=\"/WEB-INF/classes");
    }

    private void writeFilePostResource(Element postResourceEl, String path) {
        postResourceEl.setAttribute("className", JAR_RESOURCE_SET);
        postResourceEl.setAttribute("base", this.getFileHandler().getParent(path).replace("&", "&amp;"));
        postResourceEl.setAttribute("internalPath", this.getFileHandler().getName(path).replace("&", "&amp;"));
        postResourceEl.setAttribute("webAppMount", "/WEB-INF/classes");
    }

    @Override
    protected void performXmlReplacements(LocalContainer container) {
        String serverXmlFileName = "conf/server.xml";
        if (Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.connector.httpUpgradeProtocol"))) {
            this.addXmlReplacement(serverXmlFileName, this.connectorXpath() + "/UpgradeProtocol", "className", "org.apache.coyote.http2.Http2Protocol", XmlReplacement.ReplacementBehavior.ADD_MISSING_NODES);
        }
        super.performXmlReplacements(container);
    }

    @Override
    public String toString() {
        return "Tomcat 8.x Standalone Configuration";
    }
}

