/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat8xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;

public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder {
    private static final String CONNECTOR_XPATH = "//Server/Service/Connector[not(@protocol) or @protocol='HTTP/1.1' or @protocol='org.apache.coyote.http11.Http11Protocol' or @protocol='org.apache.coyote.http11.Http11NioProtocol']";
    private static final String CONNECTOR_XPATH_TEMPLATE = "//Server/Service/Connector[not(@protocol) or @protocol='HTTP/1.1' or @protocol='org.apache.coyote.http11.Http11Protocol' or @protocol='org.apache.coyote.http11.Http11NioProtocol' or @protocol='%s']";
    private boolean loggingPropertiesSet = false;

    public AbstractCatalinaStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.rmi.port", "8205");
        this.setProperty("cargo.tomcat.ajp.port", "8009");
        this.setProperty("cargo.tomcat.context.reloadable", "false");
        this.setProperty("cargo.tomcat.copywars", "true");
        this.setProperty("cargo.tomcat.uriencoding", StandardCharsets.ISO_8859_1.name());
        this.setProperty("cargo.tomcat.webappsDirectory", "webapps");
    }

    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        if ("cargo.logging".equals(name)) {
            this.loggingPropertiesSet = true;
        }
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getFileHandler().createDirectory(this.getHome(), "temp");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        if (container instanceof InstalledLocalContainer) {
            FileConfig fc;
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] classPath = installedContainer.getExtraClasspath();
            if (classPath != null) {
                for (String path : classPath) {
                    fc = new FileConfig();
                    fc.setFile(path);
                    fc.setToDir("common/lib");
                    this.setFileProperty(fc);
                }
            }
            if ((classPath = installedContainer.getSharedClasspath()) != null) {
                for (String path : classPath) {
                    fc = new FileConfig();
                    fc.setFile(path);
                    fc.setToDir("shared/lib");
                    this.setFileProperty(fc);
                }
            }
            String sourceConf = this.getFileHandler().append(installedContainer.getHome(), "conf");
            String targetConf = this.getFileHandler().createDirectory(this.getHome(), "conf");
            this.getFileHandler().copyDirectory(sourceConf, targetConf);
            this.setupConfFiles(targetConf);
        } else if (container instanceof Tomcat5xEmbeddedLocalContainer || container instanceof Tomcat8xEmbeddedLocalContainer) {
            String webXml = this.getFileHandler().append(confDir, "web.xml");
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/web.xml", webXml, this.getFileHandler(), null, StandardCharsets.UTF_8);
        }
        HashMap<String, String> replacements = new HashMap<String, String>(1);
        replacements.put("tomcat.users", this.getSecurityToken());
        String tomcatUsersXml = this.getFileHandler().append(confDir, "tomcat-users.xml");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/tomcat-users.xml", tomcatUsersXml, this.getFileHandler(), replacements, StandardCharsets.UTF_8);
        replacements.clear();
        replacements.put("catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        String loggingProperties = this.getFileHandler().append(confDir, "logging.properties");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/logging.properties", loggingProperties, this.getFileHandler(), replacements, StandardCharsets.ISO_8859_1);
        if (this.loggingPropertiesSet || container.getOutput() != null) {
            this.getLogger().warn("The Tomcat embedded container does not support changing any of the logging-related properties. Please set these in the host JVM, or use an installed local container instead.", ((Object)((Object)this)).getClass().getName());
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/context.xml", this.getFileHandler().append(confDir, "context.xml"), this.getFileHandler(), null, StandardCharsets.UTF_8);
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected String escapePath(String path) {
        String escapedPath = path;
        if (escapedPath.contains("\\")) {
            if (escapedPath.contains(":\\")) {
                escapedPath = '/' + escapedPath;
            }
            escapedPath = escapedPath.replace('\\', '/');
        }
        return escapedPath;
    }

    protected abstract void setupManager(LocalContainer var1);

    protected void setupWebApps(LocalContainer container) {
        try {
            String appDir = this.getFileHandler().createDirectory(this.getHome(), this.getPropertyValue("cargo.tomcat.webappsDirectory"));
            if (container instanceof EmbeddedLocalContainer) {
                TomcatEmbeddedLocalDeployer deployer = new TomcatEmbeddedLocalDeployer((EmbeddedLocalContainer)((AbstractCatalinaEmbeddedLocalContainer)container));
                deployer.deploy(this.getDeployables());
            } else {
                TomcatCopyingInstalledLocalDeployer deployer = this.createDeployer(container);
                deployer.setShouldCopyWars(Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.copywars")));
                deployer.deploy(this.getDeployables());
                this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(appDir, "cargocpc.war"), this.getFileHandler());
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    protected String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLoggingLevel) ? "1" : (LoggingLevel.MEDIUM.equalsLevel(cargoLoggingLevel) ? "2" : "4");
        return level;
    }

    protected String createTomcatWebappsToken() {
        StringBuilder webappTokenValue = new StringBuilder("");
        boolean copyWars = Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.copywars"));
        if (!copyWars) {
            for (Deployable deployable : this.getDeployables()) {
                if (!DeployableType.WAR.equals((Object)deployable.getType()) || TomcatUtils.containsContextFile(deployable)) continue;
                webappTokenValue.append(this.createContextToken((WAR)deployable));
                webappTokenValue.append("\n");
            }
        }
        return webappTokenValue.toString();
    }

    protected String createContextToken(WAR deployable) {
        StringBuilder contextTokenValue = new StringBuilder();
        contextTokenValue.append("<Context");
        contextTokenValue.append(" path=\"");
        if (!"".equals(deployable.getContext()) && !"/".equals(deployable.getContext())) {
            contextTokenValue.append("/" + deployable.getContext());
        }
        contextTokenValue.append("\"");
        contextTokenValue.append(" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\"");
        contextTokenValue.append(" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\"");
        contextTokenValue.append(" reloadable=\"");
        contextTokenValue.append(this.getPropertyValue("cargo.tomcat.context.reloadable"));
        contextTokenValue.append("\"");
        contextTokenValue.append(">");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }

    protected String getSecurityToken() {
        StringBuilder token = new StringBuilder("");
        if (!this.getUsers().isEmpty()) {
            StringBuilder usersToken = new StringBuilder("");
            HashSet<String> rolesSet = new HashSet<String>();
            for (User user : this.getUsers()) {
                usersToken.append("<user ");
                usersToken.append("name=\"" + user.getName() + "\" ");
                usersToken.append("password=\"" + user.getPassword() + "\" ");
                usersToken.append("roles=\"");
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    usersToken.append(role);
                    if (roles.hasNext()) {
                        usersToken.append(',');
                    }
                    rolesSet.add(role);
                }
                usersToken.append("\"/>\n  ");
            }
            StringBuilder rolesToken = new StringBuilder("");
            for (String role : rolesSet) {
                rolesToken.append("<role rolename=\"" + role + "\"/>\n  ");
            }
            token.append((CharSequence)rolesToken).append((CharSequence)usersToken);
        }
        return token.toString();
    }

    protected abstract void setupConfFiles(String var1);

    protected String getXpathForDataSourcesParent() {
        return this.getXpathForResourcesParent();
    }

    public String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getOrCreateResourceConfigurationFile(null, container);
    }

    protected Map<String, String> getNamespaces() {
        return Collections.emptyMap();
    }

    protected TomcatCopyingInstalledLocalDeployer createDeployer(LocalContainer container) {
        return new TomcatCopyingInstalledLocalDeployer(container);
    }

    protected String connectorXpath() {
        String protocolClass = this.getPropertyValue("cargo.tomcat.connector.protocolClass");
        if (protocolClass == null) {
            return CONNECTOR_XPATH;
        }
        return String.format(CONNECTOR_XPATH_TEMPLATE, protocolClass);
    }
}

