/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.util.Set;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatConfigurationBuilder;

public class Tomcat4xConfigurationBuilder
extends AbstractTomcatConfigurationBuilder {
    public Tomcat4xConfigurationBuilder() {
        this.typeToFactory.put("javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory");
    }

    public String toConfigurationEntry(Resource resource) {
        Set parameterNames;
        StringBuilder sb = new StringBuilder();
        sb.append("<Resource ").append("name=\"").append(resource.getName()).append("\"\n");
        if (resource.getClassName() != null) {
            sb.append("          ").append("type=\"").append(resource.getClassName()).append("\"\n");
        } else {
            sb.append("          ").append("type=\"").append(resource.getType()).append("\"\n");
        }
        sb.append("          ").append("auth=\"").append("Container").append("\"\n").append("          ").append("/>\n");
        if (resource.getParameter("factory") == null) {
            resource.setParameter("factory", this.getFactoryClassFor(resource.getType()));
        }
        if (!(parameterNames = resource.getParameterNames()).isEmpty()) {
            sb.append("<ResourceParams ").append("name=\"").append(resource.getName()).append("\">\n");
            for (String parameterName : parameterNames) {
                sb.append("  <parameter>\n").append("    <name>").append(parameterName).append("</name>\n").append("    <value>").append(resource.getParameter(parameterName)).append("</value>\n  </parameter>\n");
            }
            sb.append("</ResourceParams>\n");
        }
        return sb.toString();
    }

    protected String getDataSourceFactoryClass() {
        return "org.apache.commons.dbcp.BasicDataSourceFactory";
    }
}

