/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.cargo.container.internal.http.HttpFileRequest;
import org.codehaus.cargo.container.internal.http.HttpRequest;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.container.tomcat.internal.TomcatDeployableStatus;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;
import org.codehaus.cargo.util.log.LoggedObject;

public class TomcatManager
extends LoggedObject {
    private URL url;
    private String username;
    private String password;
    private String charset;
    private String userAgent;
    private int timeout = 0;

    public TomcatManager(URL url, String username, String password) {
        this(url, username, password, StandardCharsets.UTF_8);
    }

    public TomcatManager(URL url, String username, String password, Charset charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset.name();
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Charset getCharset() {
        return Charset.forName(this.charset);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void deploy(String path, URL war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, null, war, null, update, tag);
    }

    public void deploy(String path, File war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, File war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, File war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, null, null, war, update, tag);
    }

    public void deploy(String path, String version, File war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, version, null, null, war, update, tag);
    }

    public void deployContext(String path, URL config) throws TomcatManagerException, IOException {
        this.deployContext(path, config, false);
    }

    public void deployContext(String path, URL config, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, update, null);
    }

    public void deployContext(String path, URL config, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployContext(path, config, null, update, tag);
    }

    public void deployContext(String path, URL config, URL war) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, false);
    }

    public void deployContext(String path, URL config, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, update, null);
    }

    public void deployContext(String path, URL config, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, config, war, null, update, tag);
    }

    public void undeploy(String path) throws TomcatManagerException, IOException {
        this.undeploy(path, null);
    }

    public void undeploy(String path, String version) throws TomcatManagerException, IOException {
        StringBuilder sb = new StringBuilder("/undeploy");
        sb.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (version != null) {
            sb.append("&version=").append(URLEncoder.encode(version, this.charset));
        }
        this.invoke(sb.toString());
    }

    public void remove(String path) throws TomcatManagerException, IOException {
        this.invoke("/remove?path=" + URLEncoder.encode(path, this.charset));
    }

    public void reload(String path) throws TomcatManagerException, IOException {
        this.invoke("/reload?path=" + URLEncoder.encode(path, this.charset));
    }

    public void start(String path) throws TomcatManagerException, IOException {
        this.invoke("/start?path=" + URLEncoder.encode(path, this.charset));
    }

    public void stop(String path) throws TomcatManagerException, IOException {
        this.invoke("/stop?path=" + URLEncoder.encode(path, this.charset));
    }

    protected void invoke(String path) throws TomcatManagerException, IOException {
        this.invoke(path, null);
    }

    protected String invoke(String path, File fileData) throws TomcatManagerException, IOException {
        HttpResult response;
        HttpRequest request;
        this.getLogger().debug("Invoking Tomcat manager using path [" + path + "]", ((Object)((Object)this)).getClass().getName());
        URL invokeURL = new URL(this.url + path);
        if (fileData == null) {
            this.getLogger().debug("Performing GET request", ((Object)((Object)this)).getClass().getName());
            request = new HttpRequest(invokeURL, (long)this.timeout);
            request.setLogger(this.getLogger());
            request.setAuthentication(this.username, this.password);
            if (this.userAgent != null) {
                request.addRequestProperty("User-Agent", this.userAgent);
            }
            response = request.get();
        } else {
            this.getLogger().debug("Performing PUT request", ((Object)((Object)this)).getClass().getName());
            request = new HttpFileRequest(invokeURL, fileData, (long)this.timeout);
            request.setLogger(this.getLogger());
            request.setAuthentication(this.username, this.password);
            if (this.userAgent != null) {
                request.addRequestProperty("User-Agent", this.userAgent);
            }
            response = request.put();
        }
        if (!response.isSuccessful()) {
            throw new TomcatManagerException("HTTP request failed, response code: " + response.getResponseCode() + ", response message: " + response.getResponseMessage() + ", response body: " + response.getResponseBody());
        }
        String responseBody = response.getResponseBody();
        if (responseBody == null || !responseBody.startsWith("OK -")) {
            throw new TomcatManagerException("The Tomcat Manager responded \"" + responseBody + "\" instead of the expected \"OK\" message");
        }
        return responseBody;
    }

    private void deployImpl(String path, String version, URL config, URL war, File file, boolean update, String tag) throws TomcatManagerException, IOException {
        StringBuilder sb = new StringBuilder("/deploy");
        sb.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (version != null) {
            sb.append("&version=").append(URLEncoder.encode(version, this.charset));
        }
        if (config != null) {
            sb.append("&config=").append(URLEncoder.encode(config.toString(), this.charset));
        }
        if (war != null) {
            sb.append("&war=").append(URLEncoder.encode(war.toString(), this.charset));
        }
        if (update) {
            sb.append("&update=true");
        }
        if (tag != null) {
            sb.append("&tag=").append(URLEncoder.encode(tag, this.charset));
        }
        this.invoke(sb.toString(), file);
    }

    public String list() throws IOException, TomcatManagerException {
        return this.invoke("/list", null);
    }

    public TomcatDeployableStatus getStatus(String path) throws IOException, TomcatManagerException {
        return this.getStatus(path, null);
    }

    public TomcatDeployableStatus getStatus(String path, String version) throws IOException, TomcatManagerException {
        String versionIdentifier = version != null ? "##" + version : null;
        StringTokenizer records = new StringTokenizer(this.list(), "\n");
        while (records.hasMoreTokens()) {
            String record = records.nextToken();
            StringTokenizer words = new StringTokenizer(record, ":");
            while (words.hasMoreTokens()) {
                String str = words.nextToken();
                if (!path.equals(str) && (!path.equalsIgnoreCase("/ROOT") || !str.equals("/"))) continue;
                String status = words.nextToken();
                if (versionIdentifier != null) {
                    str = words.nextToken();
                    try {
                        str = words.nextToken();
                        if (!str.endsWith(versionIdentifier)) continue;
                        return TomcatDeployableStatus.toStatus(status);
                    }
                    catch (NoSuchElementException ignored) {
                        return TomcatDeployableStatus.toStatus(status);
                    }
                }
                return TomcatDeployableStatus.toStatus(status);
            }
        }
        return TomcatDeployableStatus.NOT_FOUND;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

