/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.spi.deployer.AbstractDeployer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.tomcat.Tomcat8xRuntimeConfiguration;
import org.codehaus.cargo.container.tomcat.internal.TomcatDeployableStatus;
import org.codehaus.cargo.container.tomcat.internal.TomcatManager;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;

public abstract class AbstractTomcatManagerDeployer
extends AbstractDeployer {
    private static final String NAME = "Codehaus Cargo";
    protected String managerContext = "/manager";
    private TomcatManager manager;

    public AbstractTomcatManagerDeployer(Container container) {
        super(container);
    }

    protected abstract Configuration getConfiguration();

    protected TomcatManager getTomcatManager() {
        if (this.manager == null) {
            this.manager = this.createManager(this.getConfiguration());
        }
        return this.manager;
    }

    public void deploy(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Deploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            boolean update = Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.tomcat.deploy.update"));
            this.getTomcatManager().deploy(this.getPath(deployable), this.getVersion(deployable), new File(file), update, null);
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to deploy [" + file + "]", (Throwable)exception);
        }
    }

    public void undeploy(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Undeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable), this.getVersion(deployable));
            if (status.equals(TomcatDeployableStatus.NOT_FOUND)) {
                throw new ContainerException("Deployable [" + this.getPath(deployable) + "] is not deployed");
            }
            this.performUndeploy(deployable);
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to undeploy [" + file + "]", (Throwable)exception);
        }
    }

    protected abstract void performUndeploy(Deployable var1) throws TomcatManagerException, IOException;

    public void redeploy(Deployable deployable) {
        String file = deployable.getFile();
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable), this.getVersion(deployable));
            if (!status.equals(TomcatDeployableStatus.NOT_FOUND)) {
                this.getLogger().info("Redeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
                this.undeploy(deployable);
            } else {
                this.getLogger().info("[" + file + "] is not deployed. Doing a fresh deployment.", ((Object)((Object)this)).getClass().getName());
            }
            this.deploy(deployable);
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to redeploy [" + file + "]", (Throwable)exception);
        }
    }

    public void redeploy(Deployable deployable, DeployableMonitor monitor) {
        this.redeploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForAvailability();
    }

    public void start(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Starting [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (status.equals(TomcatDeployableStatus.STOPPED)) {
                this.getTomcatManager().start(this.getPath(deployable));
            } else {
                this.getLogger().debug("Deployable [" + this.getPath(deployable) + "] already started or doesn't exist", ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to start [" + file + "]", (Throwable)exception);
        }
    }

    public void stop(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Stopping [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (status.equals(TomcatDeployableStatus.RUNNING)) {
                this.getTomcatManager().stop(this.getPath(deployable));
            } else {
                this.getLogger().debug("Deployable [" + this.getPath(deployable) + "] already stopped or doesn't exist", ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to stop [" + file + "]", (Throwable)exception);
        }
    }

    public String list() {
        this.getLogger().debug("Getting the list of applications and their statuses", ((Object)((Object)this)).getClass().getName());
        try {
            return this.getTomcatManager().list();
        }
        catch (IOException | TomcatManagerException exception) {
            throw new ContainerException("Failed to get the list of applications", (Throwable)exception);
        }
    }

    protected TomcatManager createManager(Configuration configuration) {
        URL managerURL = this.getManagerURL(configuration);
        String username = configuration.getPropertyValue("cargo.remote.username");
        String password = configuration.getPropertyValue("cargo.remote.password");
        if (username == null || password == null) {
            throw new ContainerException("The [cargo.remote.username] and [cargo.remote.password] properties are mandatory and need to be defined in your configuration.");
        }
        StringBuilder userAgent = new StringBuilder(NAME);
        String version = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        if (version != null && !version.isEmpty()) {
            userAgent.append('/');
            userAgent.append(version);
        }
        int timeout = 0;
        String timeoutStr = configuration.getPropertyValue("cargo.remote.timeout");
        if (timeoutStr != null && !timeoutStr.isEmpty()) {
            timeout = Integer.parseInt(timeoutStr);
        }
        Charset charset = configuration instanceof Tomcat8xRuntimeConfiguration ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        TomcatManager manager = new TomcatManager(managerURL, username, password, charset);
        manager.setLogger(this.getLogger());
        manager.setUserAgent(userAgent.toString());
        manager.setTimeout(timeout);
        return manager;
    }

    private URL getManagerURL(Configuration configuration) {
        URL url;
        String managerURL = configuration.getPropertyValue("cargo.remote.uri");
        if (managerURL == null) {
            managerURL = configuration.getPropertyValue("cargo.protocol") + "://" + configuration.getPropertyValue("cargo.hostname") + ":" + configuration.getPropertyValue("cargo.servlet.port") + this.managerContext;
            this.getLogger().debug("Setting Tomcat Manager URL to " + managerURL, ((Object)((Object)this)).getClass().getName());
        }
        this.getLogger().debug("Tomcat Manager URL is " + managerURL, ((Object)((Object)this)).getClass().getName());
        try {
            url = new URL(managerURL);
        }
        catch (MalformedURLException e) {
            throw new ContainerException("Invalid Tomcat Manager URL [" + managerURL + "]", (Throwable)e);
        }
        return url;
    }

    protected String getPath(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        String path = ((WAR)deployable).getContext();
        if (path.equalsIgnoreCase("ROOT")) {
            path = "";
        }
        return "/" + path;
    }

    protected String getVersion(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        return null;
    }
}

