/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.tomcat.Tomcat9xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat10x11xConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.internal.Tomcat10x11xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.util.XmlReplacement;

public class Tomcat10xStandaloneLocalConfiguration
extends Tomcat9xStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new Tomcat10x11xStandaloneLocalConfigurationCapability();

    public Tomcat10xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.tomcat.connector.keystoreType", "RSA");
        this.setProperty("cargo.tomcat.webappsLegacyDirectory", "webapps-javaee");
        this.configurationBuilder = new Tomcat10x11xConfigurationBuilder();
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    protected void setupWebApps(LocalContainer container) {
        this.getFileHandler().createDirectory(this.getHome(), this.getPropertyValue("cargo.tomcat.webappsLegacyDirectory"));
        super.setupWebApps(container);
    }

    @Override
    protected void configureHttpsConnectorXml() {
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "SSLEnabled", "true");
        String certificateXpath = this.connectorXpath() + "/SSLHostConfig/Certificate";
        this.addXmlReplacement("conf/server.xml", certificateXpath, "certificateKeystoreFile", "cargo.tomcat.connector.keystoreFile", XmlReplacement.ReplacementBehavior.ADD_MISSING_NODES);
        this.addXmlReplacement("conf/server.xml", certificateXpath, "certificateKeystorePassword", "cargo.tomcat.connector.keystorePass", XmlReplacement.ReplacementBehavior.ADD_MISSING_NODES);
        this.addXmlReplacement("conf/server.xml", certificateXpath, "type", "cargo.tomcat.connector.keystoreType", XmlReplacement.ReplacementBehavior.ADD_MISSING_NODES);
    }

    @Override
    public String toString() {
        return "Tomcat 10.x Standalone Configuration";
    }
}

