/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.DeployableVersion;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.Tomcat10xInstalledLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;
import org.codehaus.cargo.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TomcatCopyingInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private boolean shouldCopyWars = true;

    public TomcatCopyingInstalledLocalDeployer(LocalContainer container) {
        super(container);
    }

    public String getDeployableDir(Deployable deployable) {
        String propertyName = "cargo.tomcat.webappsDirectory";
        if (this.getContainer() instanceof Tomcat10xInstalledLocalContainer && (deployable.getVersion() == DeployableVersion.J2EE || deployable.getVersion() == DeployableVersion.JAVA_EE)) {
            propertyName = "cargo.tomcat.webappsLegacyDirectory";
        }
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), this.getContainer().getConfiguration().getPropertyValue(propertyName));
    }

    public void setShouldCopyWars(boolean shouldCopyWars) {
        this.shouldCopyWars = shouldCopyWars;
    }

    protected void doDeploy(String deployableDir, Deployable deployable) {
        if (DeployableType.WAR.equals((Object)deployable.getType())) {
            TomcatWAR tomcatWar;
            String tomcatContextXml;
            if (deployable instanceof TomcatWAR && (tomcatContextXml = (tomcatWar = (TomcatWAR)deployable).parseTomcatContextXml()) != null) {
                this.getLogger().warn("The WAR contains a context.xml file which sets the path to [" + tomcatContextXml + "], which means path set it the Cargo configuration will be ignored by Tomcat", ((Object)((Object)this)).getClass().getName());
            }
            WAR war = (WAR)deployable;
            if (deployable.isExpanded()) {
                if (TomcatUtils.containsContextFile((Deployable)war)) {
                    String contextDir = this.getFileHandler().createDirectory(this.getContainer().getConfiguration().getHome(), "conf/Catalina/" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
                    this.getLogger().info("Deploying WAR by creating Tomcat context XML file in [" + contextDir + "]...", ((Object)((Object)this)).getClass().getName());
                    XmlUtils xmlUtil = new XmlUtils(this.getFileHandler());
                    Document doc = xmlUtil.loadXmlFromFile(this.getFileHandler().append(war.getFile(), "META-INF/context.xml"));
                    Element context = doc.getDocumentElement();
                    context.setAttribute("docBase", war.getFile());
                    this.configureExtraClasspath(war, context);
                    xmlUtil.saveXml(doc, this.getFileHandler().append(contextDir, war.getContext() + ".xml"));
                } else if (this.shouldCopyWars) {
                    super.doDeploy(deployableDir, (Deployable)war);
                }
            } else if (TomcatUtils.containsContextFile((Deployable)war)) {
                super.doDeploy(deployableDir, (Deployable)war);
            } else if (this.shouldCopyWars) {
                super.doDeploy(deployableDir, (Deployable)war);
            }
        } else {
            super.doDeploy(deployableDir, deployable);
        }
    }

    private void configureExtraClasspath(WAR war, Element context) {
        if (war.getExtraClasspath() != null) {
            ((Tomcat5xStandaloneLocalConfiguration)this.getContainer().getConfiguration()).configureExtraClasspathToken(war, context);
        }
    }

    public void undeploy(Deployable deployable) {
        block7: {
            if (!this.getContainer().getCapability().supportsDeployableType(deployable.getType())) {
                throw new ContainerException(this.getContainer().getName() + " doesn't support [" + deployable.getType().getType().toUpperCase() + "] archives. Got [" + deployable.getFile() + "]");
            }
            String deployableDir = this.getDeployableDir(deployable);
            try {
                if (deployable.getType() == DeployableType.WAR) {
                    WAR war = (WAR)deployable;
                    this.getLogger().info("Undeploying context [" + war.getContext() + "] from [" + deployableDir + "]...", ((Object)((Object)this)).getClass().getName());
                    String warLocation = this.getFileHandler().append(deployableDir, war.getBaseFilename() + ".war");
                    String expandedwarLocation = this.getFileHandler().append(deployableDir, war.getBaseFilename());
                    if (!this.getFileHandler().exists(warLocation) && !this.getFileHandler().exists(expandedwarLocation)) {
                        throw new ContainerException("Failed to undeploy as there is no WAR at [" + warLocation + "] nor [" + expandedwarLocation + "]");
                    }
                    if (this.getFileHandler().exists(warLocation)) {
                        this.getLogger().info("Trying to delete WAR from [" + warLocation + "]...", ((Object)((Object)this)).getClass().getName());
                        this.getFileHandler().delete(warLocation);
                    }
                    if (this.getFileHandler().exists(expandedwarLocation)) {
                        this.getLogger().info("Trying to delete WAR from [" + expandedwarLocation + "]...", ((Object)((Object)this)).getClass().getName());
                        this.getFileHandler().delete(expandedwarLocation);
                    }
                    break block7;
                }
                throw new ContainerException("Only WAR undeployment is currently supported");
            }
            catch (Exception e) {
                throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "] from [" + deployableDir + "]", (Throwable)e);
            }
        }
    }

    protected String getDeployableName(Deployable deployable) {
        return super.getDeployableName(deployable).replace('/', '#');
    }
}

