/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.TomcatEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatEmbedded;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractCatalinaEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    protected TomcatEmbedded.Embedded controller;
    protected TomcatEmbedded.Host host;
    protected TomcatEmbedded.Connector connector;
    private String previousCatalinaBase;
    private Handler[] previousRootLoggerHandlers;
    private final ContainerCapability capability = new ServletContainerCapability();
    private final Map<String, WAR> scheduledDeployables = new HashMap<String, WAR>();

    public AbstractCatalinaEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public TomcatEmbedded.Embedded getController() {
        return this.controller;
    }

    public TomcatEmbedded.Host getHost() {
        return this.host;
    }

    protected void doStart() throws Exception {
        File home = new File(this.getConfiguration().getHome()).getAbsoluteFile();
        this.previousCatalinaBase = System.setProperty("catalina.base", home.getAbsolutePath());
        try {
            if (Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.tomcat.embedded.overrideJavaLogging"))) {
                LogManager lm = LogManager.getLogManager();
                String loggingFile = this.getFileHandler().append(this.getConfiguration().getHome(), "conf/logging.properties");
                if (this.getFileHandler().exists(loggingFile)) {
                    this.getLogger().info("Overriding Java logging with file [" + loggingFile + "]", ((Object)((Object)this)).getClass().getName());
                    try (InputStream is = this.getFileHandler().getInputStream(loggingFile);){
                        lm.readConfiguration(is);
                    }
                }
                if (this.getOutput() != null) {
                    this.getLogger().info("Overriding Java logging output to [" + this.getOutput() + "]", ((Object)((Object)this)).getClass().getName());
                    File[] root = lm.getLogger("");
                    this.previousRootLoggerHandlers = root.getHandlers();
                    FileHandler fileOutput = new FileHandler(this.getOutput());
                    if (this.previousRootLoggerHandlers != null) {
                        for (Handler handler : this.previousRootLoggerHandlers) {
                            fileOutput.setEncoding(handler.getEncoding());
                            fileOutput.setErrorManager(handler.getErrorManager());
                            fileOutput.setFilter(handler.getFilter());
                            fileOutput.setFormatter(handler.getFormatter());
                            fileOutput.setLevel(handler.getLevel());
                            root.removeHandler(handler);
                        }
                    }
                    root.addHandler(fileOutput);
                }
            }
            TomcatEmbedded wrapper = new TomcatEmbedded(this.getClassLoader());
            this.controller = new TomcatEmbedded.Embedded(wrapper);
            this.controller.setCatalinaBase(home);
            this.prepareController(wrapper, home, Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
            if (this.connector == null || this.host == null) {
                throw new CargoException("Programming error: attributes connector or host not set after prepareController");
            }
            this.controller.start();
            File[] webapps = new File(this.getConfiguration().getHome(), this.getConfiguration().getPropertyValue("cargo.tomcat.webappsDirectory")).listFiles();
            if (webapps != null) {
                for (File webapp : webapps) {
                    WAR war;
                    if (webapp.isFile()) {
                        String webappName = webapp.getAbsolutePath();
                        if (new File(webappName = webappName.substring(0, webappName.length() - 4)).isDirectory()) continue;
                    }
                    if (this.scheduledDeployables.containsKey((war = new WAR(webapp.getAbsolutePath())).getContext())) continue;
                    this.scheduledDeployables.put(war.getContext(), war);
                }
            }
            if (!this.scheduledDeployables.isEmpty()) {
                TomcatEmbeddedLocalDeployer deployer = new TomcatEmbeddedLocalDeployer((EmbeddedLocalContainer)this);
                HashMap<String, WAR> scheduledDeployablesCopy = new HashMap<String, WAR>(this.scheduledDeployables);
                for (Map.Entry deployable : scheduledDeployablesCopy.entrySet()) {
                    deployer.redeploy((Deployable)deployable.getValue());
                    this.scheduledDeployables.remove(deployable.getKey());
                }
            }
        }
        catch (Exception e) {
            this.restoreEnvironment();
            throw e;
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (!waitForStarting) {
            super.waitForCompletion(waitForStarting);
        }
    }

    protected void doStop() throws Exception {
        if (this.controller != null) {
            try {
                this.controller.stop();
                this.connector.destroy();
                this.controller = null;
                this.connector = null;
                this.host = null;
            }
            finally {
                this.restoreEnvironment();
            }
        } else {
            throw new ContainerException("Embedded Tomcat container is not started");
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void scheduleDeployment(Deployable deployable) {
        WAR war = (WAR)deployable;
        this.scheduledDeployables.put(war.getContext(), war);
    }

    protected abstract void prepareController(TomcatEmbedded var1, File var2, int var3);

    private void restoreEnvironment() {
        if (this.previousCatalinaBase == null) {
            System.clearProperty("catalina.base");
        } else {
            System.setProperty("catalina.base", this.previousCatalinaBase);
        }
        if (Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.tomcat.embedded.overrideJavaLogging"))) {
            this.getLogger().info("Restoring (part of) the Java logging configuration", ((Object)((Object)this)).getClass().getName());
            Logger root = LogManager.getLogManager().getLogger("");
            Handler[] currentRootLoggerHandlers = root.getHandlers();
            if (currentRootLoggerHandlers != null) {
                for (Handler handler : currentRootLoggerHandlers) {
                    root.removeHandler(handler);
                }
            }
            if (this.previousRootLoggerHandlers != null) {
                for (Handler handler : this.previousRootLoggerHandlers) {
                    root.addHandler(handler);
                }
            }
            this.getLogger().info("Restored (part of) the Java logging configuration", ((Object)((Object)this)).getClass().getName());
            this.previousRootLoggerHandlers = null;
        }
    }
}

