/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat4xConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.internal.Tomcat4xStandaloneLocalConfigurationCapability;

public class Tomcat4xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Tomcat4xStandaloneLocalConfigurationCapability();

    public Tomcat4xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new Tomcat4xConfigurationBuilder();
    }

    @Override
    protected void setupManager(LocalContainer container) {
        String from = ((InstalledLocalContainer)container).getHome();
        String to = this.getHome();
        this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
        this.getFileHandler().copyFile(from + "/webapps/manager.xml", to + "/webapps/manager.xml");
    }

    @Override
    protected void setupTransactionManager() {
        Resource transactionManagerResource = new Resource("UserTransaction", "javax.transaction.UserTransaction");
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"jotm.timeout", (Object)"60");
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"factory", (Object)"org.objectweb.jotm.UserTransactionFactory");
        transactionManagerResource.setParameters(PropertyUtils.toMap((Properties)parameters));
        this.getResources().add(transactionManagerResource);
    }

    protected String getXpathForResourcesParent() {
        return "//Engine/DefaultContext";
    }

    @Override
    public String toString() {
        return "Tomcat 4.x Standalone Configuration";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "server.xml");
    }

    @Override
    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer installedContainer;
        String[] classPath;
        if (container instanceof InstalledLocalContainer && (classPath = (installedContainer = (InstalledLocalContainer)container).getExtraClasspath()) != null) {
            String commonLib = this.getFileHandler().append(installedContainer.getHome(), "common/lib");
            for (String path : classPath) {
                String target = this.getFileHandler().append(commonLib, this.getFileHandler().getName(path));
                this.getLogger().debug("Copying extra classpath JAR to " + target, ((Object)((Object)this)).getClass().getName());
                this.getFileHandler().copyFile(path, target);
            }
        }
        super.doConfigure(container);
        String serverXml = this.getFileHandler().append(this.getHome() + "/conf", "server.xml");
        FilterChain filterChain = this.createFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", this.createTomcatWebappsToken());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", serverXml, this.getFileHandler(), filterChain, StandardCharsets.UTF_8);
    }

    @Override
    protected void setupConfFiles(String confDir) {
    }
}

