/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.spi.deployer.AbstractLocalDeployer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.internal.TomcatEmbedded;
import org.codehaus.cargo.module.webapp.tomcat.TomcatWarArchive;
import org.jdom.Attribute;

public class TomcatEmbeddedLocalDeployer
extends AbstractLocalDeployer {
    private final AbstractCatalinaEmbeddedLocalContainer container;

    public TomcatEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super((LocalContainer)container);
        this.container = (AbstractCatalinaEmbeddedLocalContainer)container;
    }

    public void deploy(Deployable deployable) {
        String docBase;
        if (this.container.getController() == null) {
            this.container.scheduleDeployment(deployable);
            return;
        }
        WAR war = (WAR)deployable;
        if (!war.isExpanded()) {
            String webappsDirectory = this.getFileHandler().append(this.container.getConfiguration().getHome(), this.container.getConfiguration().getPropertyValue("cargo.tomcat.webappsDirectory"));
            docBase = this.getFileHandler().append(webappsDirectory, war.getContext());
            this.getFileHandler().explode(war.getFile(), docBase);
        } else {
            docBase = war.getFile();
        }
        TomcatEmbedded.Context context = this.container.getController().createContext('/' + war.getContext(), docBase);
        if (this.container instanceof Tomcat5xEmbeddedLocalContainer) {
            try {
                TomcatWarArchive twar = new TomcatWarArchive(docBase);
                if (twar.getTomcatContextXml() != null) {
                    for (Map.Entry param : twar.getTomcatContextXml().getParameters().entrySet()) {
                        String key = ((Attribute)param.getKey()).getValue();
                        String value = ((Attribute)param.getValue()).getValue();
                        context.addParameter(key, value);
                    }
                }
            }
            catch (Exception e) {
                throw new ContainerException("Failed to parse Tomcat WAR file in [" + docBase + "]", (Throwable)e);
            }
            this.container.getHost().addChild(context);
        }
    }

    public void undeploy(Deployable deployable) {
        WAR war = (WAR)deployable;
        TomcatEmbedded.Context context = this.container.getHost().findChild(war.getContext());
        this.container.getHost().removeChild(context);
    }

    public void redeploy(Deployable deployable) {
        TomcatEmbedded.Context context;
        try {
            WAR war = (WAR)deployable;
            context = this.container.getHost().findChild(war.getContext());
        }
        catch (NullPointerException e) {
            this.deploy(deployable);
            return;
        }
        if (context != null) {
            context.reload();
        }
    }

    public void redeploy(Deployable deployable, DeployableMonitor monitor) {
        this.redeploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForAvailability();
    }

    public void start(Deployable deployable) {
        WAR war = (WAR)deployable;
        this.container.getHost().findChild(war.getContext()).setAvailable(true);
    }

    public void stop(Deployable deployable) {
        WAR war = (WAR)deployable;
        this.container.getHost().findChild(war.getContext()).setAvailable(false);
    }

    public DeployerType getType() {
        return DeployerType.EMBEDDED;
    }
}

