/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import org.codehaus.cargo.container.ContainerException;

public final class TomcatEmbedded {
    private Constructor embeddedNew;
    private Method embeddedCreateEngine;
    private Method embeddedCreateHost;
    private Method embeddedStart;
    private Method embeddedStop;
    private Method embeddedAddEngine;
    private Method embeddedCreateConnector;
    private Method embeddedAddConnector;
    private Method embeddedCreateContext;
    private Method embeddedSetRealm;
    private Method embeddedSetCatalinaBase;
    private Method embeddedSetCatalinaHome;
    private Method embeddedSetPort;
    private Method embeddedEnableNaming;
    private Method embeddedGetConnector;
    private Method embeddedGetEngine;
    private Method embeddedGetHost;
    private Method engineSetName;
    private Method engineAddChild;
    private Method engineSetDefaultHost;
    private Method engineSetParentClassLoader;
    private Method engineSetService;
    private Method engineSetRealm;
    private Method standardEngineSetBaseDir;
    private Method connectorDestroy;
    private Class contextClass;
    private Method contextDestroy;
    private Method contextReload;
    private Method contextSetAvailable;
    private Method contextStart;
    private Method contextStop;
    private Method contextAddParameter;
    private Method hostSetAutoDeploy;
    private Method hostGetName;
    private Method hostAddChild;
    private Method hostFindChild;
    private Method hostFindChildren;
    private Method hostRemoveChild;
    private Constructor memoryRealmNew;
    private Method memoryRealmSetPathname;
    private final ClassLoader classLoader;

    public TomcatEmbedded(ClassLoader classLoader) throws Exception {
        this.classLoader = classLoader;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.preloadEngine(classLoader);
            this.preloadMemoryRealm(classLoader);
            this.preloadEmbedded(classLoader);
            this.preloadContext(classLoader);
            this.preloadHost(classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void preloadEngine(ClassLoader classLoader) throws Exception {
        Class<?> engine = Class.forName("org.apache.catalina.Engine", true, classLoader);
        Class<?> container = Class.forName("org.apache.catalina.Container", true, classLoader);
        this.engineSetName = engine.getMethod("setName", String.class);
        this.engineAddChild = engine.getMethod("addChild", container);
        this.engineSetDefaultHost = engine.getMethod("setDefaultHost", String.class);
        this.engineSetParentClassLoader = engine.getMethod("setParentClassLoader", ClassLoader.class);
        Class<?> service = Class.forName("org.apache.catalina.Service", true, classLoader);
        this.engineSetService = engine.getMethod("setService", service);
        Class<?> standardEngine = Class.forName("org.apache.catalina.core.StandardEngine", true, classLoader);
        try {
            this.standardEngineSetBaseDir = standardEngine.getMethod("setBaseDir", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void preloadMemoryRealm(ClassLoader classLoader) throws Exception {
        Class<?> memoryRealm = Class.forName("org.apache.catalina.realm.MemoryRealm", true, classLoader);
        this.memoryRealmNew = memoryRealm.getConstructor(new Class[0]);
        this.memoryRealmSetPathname = memoryRealm.getMethod("setPathname", String.class);
    }

    private void preloadContext(ClassLoader classLoader) throws Exception {
        this.contextClass = Class.forName("org.apache.catalina.Context", true, classLoader);
        try {
            this.contextDestroy = this.contextClass.getMethod("destroy", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.contextReload = this.contextClass.getMethod("reload", new Class[0]);
        try {
            this.contextSetAvailable = this.contextClass.getMethod("setAvailable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.contextStart = this.contextClass.getMethod("start", new Class[0]);
            this.contextStop = this.contextClass.getMethod("stop", new Class[0]);
        }
        this.contextAddParameter = this.contextClass.getMethod("addParameter", String.class, String.class);
    }

    private void preloadHost(ClassLoader classLoader) throws Exception {
        Class<?> container = Class.forName("org.apache.catalina.Container", true, classLoader);
        Class<?> host = Class.forName("org.apache.catalina.Host", true, classLoader);
        this.hostSetAutoDeploy = host.getMethod("setAutoDeploy", Boolean.TYPE);
        this.hostGetName = host.getMethod("getName", new Class[0]);
        this.hostAddChild = host.getMethod("addChild", container);
        this.hostFindChild = host.getMethod("findChild", String.class);
        this.hostFindChildren = host.getMethod("findChildren", new Class[0]);
        this.hostRemoveChild = host.getMethod("removeChild", container);
    }

    private void preloadEmbedded(ClassLoader classLoader) throws Exception {
        Class<?> embedded;
        Class<?> connector;
        Class<?> realm = Class.forName("org.apache.catalina.Realm", true, classLoader);
        try {
            connector = Class.forName("org.apache.catalina.Connector", true, classLoader);
        }
        catch (ClassNotFoundException e) {
            connector = Class.forName("org.apache.catalina.connector.Connector", true, classLoader);
        }
        Class<?> engine = Class.forName("org.apache.catalina.Engine", true, classLoader);
        try {
            embedded = Class.forName("org.apache.catalina.startup.Embedded", true, classLoader);
            this.embeddedCreateEngine = embedded.getMethod("createEngine", new Class[0]);
            this.embeddedCreateHost = embedded.getMethod("createHost", String.class, String.class);
            this.embeddedAddEngine = embedded.getMethod("addEngine", engine);
            this.embeddedCreateConnector = embedded.getMethod("createConnector", InetAddress.class, Integer.TYPE, Boolean.TYPE);
            this.embeddedAddConnector = embedded.getMethod("addConnector", connector);
            this.embeddedCreateContext = embedded.getMethod("createContext", String.class, String.class);
            this.embeddedSetRealm = embedded.getMethod("setRealm", realm);
            this.embeddedSetCatalinaBase = embedded.getMethod("setCatalinaBase", String.class);
            this.embeddedSetCatalinaHome = embedded.getMethod("setCatalinaHome", String.class);
        }
        catch (ClassNotFoundException e) {
            embedded = Class.forName("org.apache.catalina.startup.Tomcat", true, classLoader);
            this.embeddedSetCatalinaBase = embedded.getMethod("setBaseDir", String.class);
            this.embeddedSetPort = embedded.getMethod("setPort", Integer.TYPE);
            this.embeddedEnableNaming = embedded.getMethod("enableNaming", new Class[0]);
            this.embeddedGetConnector = embedded.getMethod("getConnector", new Class[0]);
            this.embeddedGetEngine = embedded.getMethod("getEngine", new Class[0]);
            this.embeddedGetHost = embedded.getMethod("getHost", new Class[0]);
            this.engineSetRealm = engine.getMethod("setRealm", realm);
            this.embeddedCreateContext = embedded.getMethod("addWebapp", String.class, String.class);
            Class<?> tomcatURLStreamHandlerFactory = Class.forName("org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", true, classLoader);
            Method getInstance = tomcatURLStreamHandlerFactory.getMethod("getInstance", new Class[0]);
            getInstance.invoke(null, new Object[0]);
        }
        this.embeddedNew = embedded.getConstructor(new Class[0]);
        this.embeddedStart = embedded.getMethod("start", new Class[0]);
        this.embeddedStop = embedded.getMethod("stop", new Class[0]);
        this.connectorDestroy = connector.getMethod("destroy", new Class[0]);
    }

    private Object newInstance(Constructor c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object t = c.newInstance(new Object[0]);
            return t;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public final class MemoryRealm
    extends Wrapper {
        public MemoryRealm() {
            super(TomcatEmbedded.this.newInstance(TomcatEmbedded.this.memoryRealmNew));
        }

        public void setPathname(File path) {
            this.invoke(TomcatEmbedded.this.memoryRealmSetPathname, path.toString());
        }
    }

    public final class Engine
    extends Wrapper {
        public Engine(Object core, Object service) {
            super(core);
            if (service != null) {
                this.invoke(TomcatEmbedded.this.engineSetService, service);
            }
        }

        public void setName(String name) {
            this.invoke(TomcatEmbedded.this.engineSetName, name);
        }

        public void setBaseDir(String baseDir) {
            this.invoke(TomcatEmbedded.this.standardEngineSetBaseDir, baseDir);
        }

        public void addChild(Host host) {
            this.invoke(TomcatEmbedded.this.engineAddChild, host);
        }

        public void setDefaultHost(String name) {
            this.invoke(TomcatEmbedded.this.engineSetDefaultHost, name);
        }

        public void setParentClassLoader(ClassLoader cl) {
            this.invoke(TomcatEmbedded.this.engineSetParentClassLoader, cl);
        }

        public void setRealm(MemoryRealm realm) {
            this.invoke(TomcatEmbedded.this.engineSetRealm, realm);
        }
    }

    public final class Connector
    extends Wrapper {
        public Connector(Object core) {
            super(core);
        }

        public void destroy() {
            this.invoke(TomcatEmbedded.this.connectorDestroy);
        }
    }

    public final class Embedded
    extends Wrapper {
        public Embedded() {
            super(TomcatEmbedded.this.newInstance(TomcatEmbedded.this.embeddedNew));
        }

        public Engine createEngine() {
            return new Engine(this.invoke(TomcatEmbedded.this.embeddedCreateEngine), this.core);
        }

        public Host createHost(String name, File appBase) {
            return new Host(this.invoke(TomcatEmbedded.this.embeddedCreateHost, name, appBase.getAbsolutePath()));
        }

        public void start() {
            this.invoke(TomcatEmbedded.this.embeddedStart);
        }

        public void stop() {
            this.invoke(TomcatEmbedded.this.embeddedStop);
        }

        public void addEngine(Engine e) {
            this.invoke(TomcatEmbedded.this.embeddedAddEngine, e);
        }

        public Connector createConnector(InetAddress inetAddress, int port, boolean secure) {
            return new Connector(this.invoke(TomcatEmbedded.this.embeddedCreateConnector, inetAddress, port, secure));
        }

        public void addConnector(Connector connector) {
            this.invoke(TomcatEmbedded.this.embeddedAddConnector, connector);
        }

        public Context createContext(String path, String docBase) {
            return new Context(this.invoke(TomcatEmbedded.this.embeddedCreateContext, path, new File(docBase).getAbsolutePath()));
        }

        public void setRealm(MemoryRealm realm) {
            this.invoke(TomcatEmbedded.this.embeddedSetRealm, realm);
        }

        public void setCatalinaBase(File dir) {
            this.invoke(TomcatEmbedded.this.embeddedSetCatalinaBase, dir.getAbsolutePath());
        }

        public void setCatalinaHome(File dir) {
            this.invoke(TomcatEmbedded.this.embeddedSetCatalinaHome, dir.getAbsolutePath());
        }

        public void setPort(int port) {
            this.invoke(TomcatEmbedded.this.embeddedSetPort, port);
        }

        public void enableNaming() {
            this.invoke(TomcatEmbedded.this.embeddedEnableNaming);
        }

        public Connector getConnector() {
            return new Connector(this.invoke(TomcatEmbedded.this.embeddedGetConnector));
        }

        public Engine getEngine() {
            return new Engine(this.invoke(TomcatEmbedded.this.embeddedGetEngine), null);
        }

        public Host getHost() {
            return new Host(this.invoke(TomcatEmbedded.this.embeddedGetHost));
        }
    }

    public final class Host
    extends Wrapper {
        public Host(Object core) {
            super(core);
        }

        public void setAutoDeploy(boolean b) {
            this.invoke(TomcatEmbedded.this.hostSetAutoDeploy, b);
        }

        public String getName() {
            return (String)this.invoke(TomcatEmbedded.this.hostGetName);
        }

        public void addChild(Context context) {
            this.invoke(TomcatEmbedded.this.hostAddChild, context);
        }

        public Context[] findChildren() {
            Object[] children;
            ArrayList<Context> contexts = new ArrayList<Context>();
            for (Object child : children = (Object[])this.invoke(TomcatEmbedded.this.hostFindChildren)) {
                if (!child.getClass().isAssignableFrom(TomcatEmbedded.this.contextClass)) continue;
                contexts.add(new Context(child));
            }
            Context[] contextsArray = new Context[contexts.size()];
            contextsArray = contexts.toArray(contextsArray);
            return contextsArray;
        }

        public Context findChild(String name) {
            return new Context(this.invoke(TomcatEmbedded.this.hostFindChild, name));
        }

        public void removeChild(Context context) {
            this.invoke(TomcatEmbedded.this.hostRemoveChild, context);
        }
    }

    public final class Context
    extends Wrapper {
        public Context(Object context) {
            super(context);
        }

        public void destroy() {
            this.invoke(TomcatEmbedded.this.contextDestroy);
        }

        public void reload() {
            this.invoke(TomcatEmbedded.this.contextReload);
        }

        public void setAvailable(boolean b) {
            if (TomcatEmbedded.this.contextSetAvailable != null) {
                this.invoke(TomcatEmbedded.this.contextSetAvailable, b);
            } else if (b) {
                this.invoke(TomcatEmbedded.this.contextStart);
            } else {
                this.invoke(TomcatEmbedded.this.contextStop);
            }
        }

        public void addParameter(String key, String value) {
            this.invoke(TomcatEmbedded.this.contextAddParameter, key, value);
        }
    }

    private class Wrapper {
        protected final Object core;

        public Wrapper(Object core) {
            if (core == null) {
                throw new NullPointerException("Passed core is null");
            }
            this.core = core;
        }

        protected Object invoke(Method method) {
            return this.invoke(method, new Object[0]);
        }

        protected Object invoke(Method method, Object arg1) {
            return this.invoke(method, new Object[]{arg1});
        }

        protected Object invoke(Method method, Object arg1, Object arg2) {
            return this.invoke(method, new Object[]{arg1, arg2});
        }

        protected Object invoke(Method method, Object arg1, Object arg2, Object arg3) {
            return this.invoke(method, new Object[]{arg1, arg2, arg3});
        }

        protected Object invoke(Method method, Object[] args) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Wrapper)) continue;
                args[i] = ((Wrapper)args[i]).core;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(TomcatEmbedded.this.classLoader);
            try {
                Object object = method.invoke(this.core, args);
                return object;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

