/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.util.FileHandler;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class WebLogic8xConfigXmlInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    public WebLogic8xConfigXmlInstalledLocalDeployer(LocalContainer container) {
        super(container);
        FileHandler handler = container.getFileHandler();
        this.setFileHandler(handler);
    }

    public Document readConfigXml() {
        Document configXml;
        try {
            configXml = new SAXReader().read(this.getFileHandler().getInputStream(this.getFileHandler().append(this.getDomainHome(), "config.xml")));
        }
        catch (DocumentException e) {
            throw new ContainerException("Error parsing config.xml for " + this.getServerName(), (Throwable)e);
        }
        return configXml;
    }

    public void writeConfigXml(Document configXml) {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        try {
            XMLWriter writer = new XMLWriter(this.getFileHandler().getOutputStream(this.getFileHandler().append(this.getDomainHome(), "config.xml")), outformat);
            writer.write(configXml);
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new ContainerException("Error encoding config.xml for " + this.getServerName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ContainerException("Error writing config.xml for " + this.getServerName(), (Throwable)e);
        }
    }

    protected String getDomainHome() {
        return ((WebLogicConfiguration)this.getContainer().getConfiguration()).getDomainHome();
    }

    public void deploy(Deployable deployable) {
        Document configXml = this.readConfigXml();
        XPath xpathSelector = DocumentHelper.createXPath((String)"//Domain");
        List results = xpathSelector.selectNodes((Object)configXml);
        Element domain = (Element)results.get(0);
        if (deployable.getType() == DeployableType.WAR) {
            this.addWarToDomain((WAR)deployable, domain);
        } else if (deployable.getType() == DeployableType.EAR) {
            this.addEarToDomain((EAR)deployable, domain);
        } else {
            throw new ContainerException("Not supported");
        }
        this.writeConfigXml(configXml);
    }

    public void undeploy(Deployable deployable) {
        Document configXml = this.readConfigXml();
        XPath xpathSelector = DocumentHelper.createXPath((String)("//Application[@Path='" + this.getFileHandler().getParent(this.getAbsolutePath(deployable)) + "']"));
        List results = xpathSelector.selectNodes((Object)configXml);
        for (Element element : results) {
            configXml.remove(element);
        }
        this.writeConfigXml(configXml);
    }

    protected void addWarToDomain(WAR war, Element domain) {
        Element application = domain.addElement("Application");
        application.addAttribute("Name", "_" + war.getContext() + "_app");
        application.addAttribute("Path", this.getFileHandler().getParent(this.getAbsolutePath((Deployable)war)));
        application.addAttribute("StagingMode", "nostage");
        application.addAttribute("TwoPhase", "false");
        Element webAppComponent = application.addElement("WebAppComponent");
        webAppComponent.addAttribute("Name", war.getContext());
        webAppComponent.addAttribute("Targets", this.getServerName());
        webAppComponent.addAttribute("URI", this.getURI((Deployable)war));
    }

    protected void addEarToDomain(EAR ear, Element domain) {
        Element application = domain.addElement("Application");
        application.addAttribute("Name", "_" + ear.getName() + "_app");
        application.addAttribute("Path", this.getAbsolutePath((Deployable)ear));
        application.addAttribute("StagingMode", "nostage");
        application.addAttribute("TwoPhase", "false");
        Iterator contexts = ear.getWebContexts();
        while (contexts.hasNext()) {
            String context = (String)contexts.next();
            Element webAppComponent = application.addElement("WebAppComponent");
            webAppComponent.addAttribute("Name", context);
            webAppComponent.addAttribute("Targets", this.getServerName());
            webAppComponent.addAttribute("URI", ear.getWebUri(context));
        }
    }

    protected String getServerName() {
        return this.getContainer().getConfiguration().getPropertyValue("cargo.weblogic.server");
    }

    String getURI(Deployable deployable) {
        String path = deployable.getFile();
        return new File(path).getName();
    }

    String getAbsolutePath(Deployable deployable) {
        String path = deployable.getFile();
        return this.getFileHandler().getAbsolutePath(path);
    }
}

