/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableException;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.util.Dom4JUtil;
import org.codehaus.cargo.util.FileHandler;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WebLogic9xConfigXmlInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    protected static final String RESOURCE_PATH = "/org/codehaus/cargo/container/internal/resources/";
    private Dom4JUtil xmlTool = new Dom4JUtil();

    public WebLogic9xConfigXmlInstalledLocalDeployer(InstalledLocalContainer container) {
        super((LocalContainer)container);
        this.xmlTool.getNamespaces().put("weblogic", "http://www.bea.com/ns/weblogic/920/domain");
        FileHandler handler = container.getFileHandler();
        this.setFileHandler(handler);
        this.xmlTool.setFileHandler(handler);
    }

    public Document readConfigXml() {
        String configFile = this.getConfigXmlPath();
        return this.xmlTool.loadXmlFromFile(configFile);
    }

    protected String getConfigXmlPath() {
        String configDir = this.getFileHandler().append(this.getDomainHome(), "config");
        String configFile = this.getFileHandler().append(configDir, "config.xml");
        return configFile;
    }

    public void writeConfigXml(Document configXml) {
        String configFile = this.getConfigXmlPath();
        this.xmlTool.saveXml(configXml, configFile);
    }

    protected String getDomainHome() {
        return ((WebLogicConfiguration)this.getContainer().getConfiguration()).getDomainHome();
    }

    public void deploy(Deployable deployable) {
        Document configXml = this.readConfigXml();
        Element domain = configXml.getRootElement();
        this.addDeployableToDomain(deployable, domain);
        this.writeConfigXml(configXml);
    }

    public void undeploy(Deployable deployable) {
        Document configXml = this.readConfigXml();
        Element domain = configXml.getRootElement();
        this.removeDeployableFromDomain(deployable, domain);
        this.writeConfigXml(configXml);
    }

    protected void removeDeployableFromDomain(Deployable deployable, Element domain) {
        List results = this.selectAppDeployments(deployable, domain);
        for (Element element : results) {
            domain.remove(element);
        }
    }

    protected List selectAppDeployments(Deployable deployable, Element domain) {
        String xpath = "//weblogic:app-deployment[weblogic:name/text()='" + this.createIdForDeployable(deployable) + "']";
        Element toSearch = domain;
        return this.xmlTool.selectElementsMatchingXPath(xpath, toSearch);
    }

    protected void addDeployableToDomain(Deployable deployable, Element domain) {
        this.createElementForDeployableInDomain(deployable, domain);
        this.reorderAppDeploymentsAfterConfigurationVersion(domain);
    }

    protected Element createElementForDeployableInDomain(Deployable deployable, Element domain) {
        QName appDeploymentQName = new QName("app-deployment", new Namespace("", "http://www.bea.com/ns/weblogic/920/domain"));
        Element appDeployment = domain.addElement(appDeploymentQName);
        String id = this.createIdForDeployable(deployable);
        Element appId = appDeployment.addElement("name");
        appId.setText(id);
        Element target = appDeployment.addElement("target");
        target.setText(this.getServerName());
        Element sourcePath = appDeployment.addElement("source-path");
        sourcePath.setText(this.getAbsolutePath(deployable));
        return appDeployment;
    }

    protected void reorderAppDeploymentsAfterConfigurationVersion(Element domain) {
        Element configurationVersion = this.xmlTool.selectElementMatchingXPath("weblogic:configuration-version", domain);
        List appDeployments = this.xmlTool.selectElementsMatchingXPath("weblogic:app-deployment", domain);
        List domainElements = domain.content();
        int indexOfConfigurationVersion = domainElements.indexOf(configurationVersion);
        domainElements.removeAll(appDeployments);
        domainElements.addAll(indexOfConfigurationVersion + 1, appDeployments);
    }

    protected String createIdForDeployable(Deployable deployable) {
        String name = null;
        if (deployable.getType() == DeployableType.WAR) {
            name = ((WAR)deployable).getContext();
        } else if (deployable.getType() == DeployableType.EAR) {
            name = ((EAR)deployable).getName();
        } else if (deployable.getType() == DeployableType.EJB || deployable.getType() == DeployableType.RAR) {
            name = this.createIdFromFileName(deployable);
        } else {
            throw new DeployableException("name extraction for " + deployable.getType() + " not currently supported");
        }
        return name;
    }

    protected String createIdFromFileName(Deployable deployable) {
        File file = new File(deployable.getFile());
        return file.getName();
    }

    protected String getServerName() {
        return this.getContainer().getConfiguration().getPropertyValue("cargo.weblogic.server");
    }

    String getURI(Deployable deployable) {
        String path = deployable.getFile();
        return new File(path).getName();
    }

    String getAbsolutePath(Deployable deployable) {
        String path = deployable.getFile();
        return this.getFileHandler().getAbsolutePath(path);
    }
}

