/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;

public abstract class AbstractWebLogicInstalledLocalContainer
extends AbstractInstalledLocalContainer
implements WebLogicLocalContainer {
    private String beaHome;
    private ContainerCapability capability = new J2EEContainerCapability();

    public AbstractWebLogicInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public final void setBeaHome(String beaHome) {
        this.beaHome = beaHome;
    }

    public final ContainerCapability getCapability() {
        return this.capability;
    }

    protected final void verify() {
        super.verify();
        this.initBeaHome();
        this.verifyBeaHome();
        this.verifyWeblogicHome();
    }

    protected List getBeaHomeFiles() {
        ArrayList<String> requiredFiles = new ArrayList<String>();
        requiredFiles.add(this.getFileHandler().append(this.getBeaHome(), "registry.xml"));
        return requiredFiles;
    }

    protected List getBeaHomeDirs() {
        return new ArrayList();
    }

    protected List getWeblogicHomeFiles() {
        ArrayList<String> requiredFiles = new ArrayList<String>();
        requiredFiles.add(this.getFileHandler().append(this.getWeblogicHome(), "server/lib/weblogic.jar"));
        return requiredFiles;
    }

    protected List getWeblogicHomeDirs() {
        ArrayList<String> requiredDirs = new ArrayList<String>();
        requiredDirs.add(this.getFileHandler().append(this.getWeblogicHome(), "server/lib"));
        return requiredDirs;
    }

    protected void verifyWeblogicHome() {
        List requiredDirs = this.getWeblogicHomeDirs();
        List requiredFiles = this.getWeblogicHomeFiles();
        String errorPrefix = "Invalid Weblogic installation. ";
        String errorSuffix = "Make sure the WL_HOME directory you have specified points to the right location (It's currently pointing to [" + this.getWeblogicHome() + "])";
        this.verify(errorPrefix, errorSuffix, requiredDirs, requiredFiles);
    }

    protected void verifyBeaHome() {
        List requiredDirs = this.getBeaHomeDirs();
        List requiredFiles = this.getBeaHomeFiles();
        String errorPrefix = "Invalid Weblogic installation. ";
        String errorSuffix = "Make sure the BEA_HOME directory you have specified points to the right location (It's currently pointing to [" + this.getBeaHome() + "])";
        this.verify(errorPrefix, errorSuffix, requiredDirs, requiredFiles);
    }

    protected void verify(String errorPrefix, String errorSuffix, List requiredDirs, List requiredFiles) {
        for (String dir : requiredDirs) {
            if (!this.getFileHandler().exists(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] directory doesn't exist. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectory(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] path should be a directory. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectoryEmpty(dir)) continue;
            throw new ContainerException(errorPrefix + "The [" + dir + "] directory is empty and it shouldn't be. " + errorSuffix);
        }
        for (String file : requiredFiles) {
            if (this.getFileHandler().exists(file)) continue;
            throw new ContainerException(errorPrefix + "The [" + file + "] file doesn't exist. " + errorSuffix);
        }
    }

    public final void initBeaHome() {
        if (this.getHome() == null) {
            throw new ContainerException("Please set container home to WL_HOME");
        }
        if (this.getBeaHome() == null) {
            this.setBeaHome(this.getConfiguration().getPropertyValue("cargo.weblogic.bea.home"));
        }
        if (this.getBeaHome() == null) {
            this.setBeaHome(new File(this.getHome()).getParent());
        }
    }

    public final void doStart(Java java) throws Exception {
        this.initBeaHome();
        java.setDir(new File(this.getConfiguration().getHome()));
        File serverDir = new File(this.getHome(), "server");
        if (this.getConfiguration().getPropertyValue("cargo.servlet.port") != null) {
            java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.ListenPort", this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        }
        if (this.getConfiguration().getPropertyValue("cargo.hostname") != null) {
            java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.ListenAddress", this.getConfiguration().getPropertyValue("cargo.hostname")));
        }
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.name", this.getConfiguration().getPropertyValue("cargo.weblogic.server")));
        java.addSysproperty(this.getAntUtils().createSysProperty("bea.home", this.getBeaHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.username", this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.user")));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.password", this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.password")));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.security.policy", "=" + serverDir + "/lib/weblogic.policy"));
        Path classpath = java.getCommandLine().getClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        classpath.createPathElement().setLocation(new File(this.getConfiguration().getHome()));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("weblogic.Server");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }

    public final void doStop(Java java) throws Exception {
        File serverDir = new File(this.getHome(), "server");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        java.setClassname("weblogic.Admin");
        java.createArg().setValue("-url");
        java.createArg().setValue("t3://" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.servlet.port"));
        java.createArg().setValue("-username");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.user"));
        java.createArg().setValue("-password");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.password"));
        java.createArg().setValue("FORCESHUTDOWN");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }

    public String getBeaHome() {
        return this.beaHome;
    }

    public String getDomainHome() {
        return this.getConfiguration().getHome();
    }

    public String getWeblogicHome() {
        return this.getHome();
    }
}

