/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container;

public class ContainerType {
    public static final ContainerType INSTALLED = new ContainerType("installed");
    public static final ContainerType EMBEDDED = new ContainerType("embedded");
    public static final ContainerType REMOTE = new ContainerType("remote");
    private String type;

    public ContainerType(String type) {
        this.type = type;
    }

    public static ContainerType toType(String typeAsString) {
        ContainerType type = typeAsString.equalsIgnoreCase(INSTALLED.getType()) ? INSTALLED : (typeAsString.equalsIgnoreCase(EMBEDDED.getType()) ? EMBEDDED : (typeAsString.equalsIgnoreCase(REMOTE.getType()) ? REMOTE : new ContainerType(typeAsString)));
        return type;
    }

    public boolean equals(Object object) {
        ContainerType type;
        boolean result = false;
        if (object != null && object instanceof ContainerType && (type = (ContainerType)object).getType().equals(this.getType())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType();
    }

    public boolean isLocal() {
        return this == INSTALLED || this == EMBEDDED;
    }

    public boolean isRemote() {
        return this == REMOTE;
    }
}

