/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.geronimo.GeronimoInstalledLocalDeployer;
import org.codehaus.cargo.container.geronimo.internal.GeronimoUtils;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public class Geronimo1xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "geronimo1x";
    private ContainerCapability capability = new J2EEContainerCapability();
    private GeronimoUtils geronimoUtils;

    public Geronimo1xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.geronimoUtils = new GeronimoUtils(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Geronimo " + this.getVersion("1.x");
    }

    protected void doStart(Java java) throws Exception {
        java.setJar(new File(this.getConfiguration().getHome(), "bin/server.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.server.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getPath()));
        AntContainerExecutorThread geronimoStarter = new AntContainerExecutorThread(java);
        geronimoStarter.start();
        this.waitForCompletion(true);
        GeronimoInstalledLocalDeployer deployer = new GeronimoInstalledLocalDeployer(this);
        Iterator iterator = this.getConfiguration().getDeployables().iterator();
        while (iterator.hasNext()) {
            deployer.deploy((Deployable)iterator.next());
        }
    }

    protected void doStop(Java java) throws Exception {
        java.setJar(new File(this.getConfiguration().getHome(), "bin/shutdown.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.server.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getPath()));
        java.createArg().setValue("--user");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.username"));
        java.createArg().setValue("--password");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.password"));
        java.createArg().setValue("--port");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        AntContainerExecutorThread geronimoStopper = new AntContainerExecutorThread(java);
        geronimoStopper.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        boolean bl;
        boolean exitCondition;
        this.getLogger().debug("Checking if Geronimo is started using: hostname [" + this.getConfiguration().getPropertyValue("cargo.hostname") + "], RMI port [" + this.getConfiguration().getPropertyValue("cargo.rmi.port") + "], username [" + this.getConfiguration().getPropertyValue("cargo.remote.username") + "], password [" + this.getConfiguration().getPropertyValue("cargo.remote.password") + "]", this.getClass().getName());
        long startTime = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - startTime > this.getTimeout()) {
                this.setState(State.UNKNOWN);
                String message = "Container failed to start within the timeout period [" + this.getTimeout() + "]. The Container state is thus unknown.";
                this.getLogger().info(message, this.getClass().getName());
                throw new ContainerException(message);
            }
            Thread.sleep(1000L);
            boolean isStarted = this.geronimoUtils.isGeronimoStarted();
            if (waitForStarting) {
                if (!isStarted) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = isStarted;
        } while (exitCondition = bl);
        Thread.sleep(5000L);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected String getVersion(String defaultVersion) {
        return defaultVersion;
    }
}

