/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.geronimo.Geronimo1xInstalledLocalContainer;
import org.codehaus.cargo.container.geronimo.GeronimoInstalledLocalDeployer;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;

public class Geronimo2xInstalledLocalContainer
extends Geronimo1xInstalledLocalContainer {
    public static final String ID = "geronimo2x";

    public Geronimo2xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Geronimo " + this.getVersion("2.x");
    }

    protected void doStart(Java java) throws Exception {
        java.setJar(new File(this.getHome(), "bin/server.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.home.dir", this.getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.server.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.endorsed.dirs", new File(this.getHome(), "lib/endorsed").getAbsolutePath().replace(File.separatorChar, '/')));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getAbsolutePath().replace(File.separatorChar, '/')));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.config.substitution.NamingPort", this.getConfiguration().getPropertyValue("cargo.rmi.port")));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.config.substitution.HTTPPort", this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.config.substitution.EndPointURI", "http://localhost:" + this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        AntContainerExecutorThread geronimoStarter = new AntContainerExecutorThread(java);
        geronimoStarter.start();
        this.waitForCompletion(true);
        GeronimoInstalledLocalDeployer deployer = new GeronimoInstalledLocalDeployer(this);
        Iterator iterator = this.getConfiguration().getDeployables().iterator();
        while (iterator.hasNext()) {
            deployer.deploy((Deployable)iterator.next());
        }
    }

    protected void doStop(Java java) throws Exception {
        java.setJar(new File(this.getHome(), "bin/shutdown.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.server.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getPath()));
        java.createArg().setValue("--user");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.username"));
        java.createArg().setValue("--password");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.password"));
        java.createArg().setValue("--port");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        AntContainerExecutorThread geronimoStopper = new AntContainerExecutorThread(java);
        geronimoStopper.start();
    }

    protected String getVersion(String defaultVersion) {
        return defaultVersion;
    }
}

