/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;

public class GeronimoUtils {
    private String host;
    private String rmiPort;
    private String username;
    private String password;

    public GeronimoUtils(Configuration configuration) {
        this.host = configuration.getPropertyValue("cargo.hostname");
        this.rmiPort = configuration.getPropertyValue("cargo.rmi.port");
        this.username = configuration.getPropertyValue("cargo.remote.username");
        this.password = configuration.getPropertyValue("cargo.remote.password");
    }

    public boolean isGeronimoStarted() {
        boolean isStarted = false;
        try {
            isStarted = this.isKernelFullyStarted(this.host, this.rmiPort, this.username, this.password);
        }
        catch (IOException e) {
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            throw new ContainerException("Internal error in the Geronimo container", e);
        }
        return isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKernelFullyStarted(String host, String rmiPort, String username, String password) throws Exception {
        JMXServiceURL jmxServiceURL = new JMXServiceURL("service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + rmiPort + "/JMXConnector");
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("jmx.remote.credentials", new String[]{username, password});
        JMXConnector connector = JMXConnectorFactory.connect(jmxServiceURL, map);
        try {
            MBeanServerConnection mbServerConnection = connector.getMBeanServerConnection();
            Set<ObjectName> attributeManagers = mbServerConnection.queryNames(new ObjectName("*:name=AttributeManager,*"), null);
            if (attributeManagers == null || attributeManagers.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean result = true;
            for (ObjectName attributeManager : attributeManagers) {
                try {
                    Boolean kernelFullyStarted = (Boolean)mbServerConnection.getAttribute(attributeManager, "kernelFullyStarted");
                    if (kernelFullyStarted.booleanValue()) continue;
                    result = false;
                    break;
                }
                catch (AttributeNotFoundException ignored) {
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                connector.close();
            }
            catch (IOException ignored) {}
            connector = null;
            System.gc();
        }
    }

    private boolean isKernelAlive(Object kernel) throws Exception {
        Boolean running = (Boolean)kernel.getClass().getMethod("isRunning", null).invoke(kernel, (Object[])null);
        return running;
    }
}

