/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.jboss.internal.HttpURLConnection;
import org.codehaus.cargo.container.jboss.internal.ISimpleHttpFileServer;
import org.codehaus.cargo.container.jboss.internal.JdkHttpURLConnection;
import org.codehaus.cargo.container.jboss.internal.SimpleHttpFileServer;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public class JBoss4xRemoteDeployer
extends AbstractRemoteDeployer {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private String deployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=deploy&argType=java.net.URL&arg0=";
    private String undeployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=undeploy&argType=java.net.URL&arg0=";
    private String redeployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=redeploy&argType=java.net.URL&arg0=";
    private RuntimeConfiguration configuration;
    private HttpURLConnection connection;
    private InetSocketAddress deployableServerSocketAddress;
    private FileHandler fileHandler;
    private ISimpleHttpFileServer fileServer;

    public JBoss4xRemoteDeployer(RemoteContainer container) {
        this(container, new JdkHttpURLConnection(), new SimpleHttpFileServer());
    }

    protected JBoss4xRemoteDeployer(RemoteContainer container, HttpURLConnection connection, ISimpleHttpFileServer fileServer) {
        this.configuration = container.getConfiguration();
        this.connection = connection;
        this.deployableServerSocketAddress = this.buildSocketAddressForDeployableServer();
        this.fileHandler = new DefaultFileHandler();
        this.fileServer = fileServer;
        this.connection.setTimeout(120000);
    }

    public void setDeployURL(String deployURL) {
        this.deployURL = deployURL;
    }

    public void setUndeployURL(String undeployURL) {
        this.undeployURL = undeployURL;
    }

    public void setRedeployURL(String redeployURL) {
        this.redeployURL = redeployURL;
    }

    public void deploy(Deployable deployable) {
        this.invokeRemotely(deployable, this.deployURL, true);
    }

    public void undeploy(Deployable deployable) {
        this.invokeRemotely(deployable, this.undeployURL, false);
    }

    public void redeploy(Deployable deployable) {
        this.invokeRemotely(deployable, this.redeployURL, true);
    }

    private void invokeRemotely(Deployable deployable, String jmxConsoleURL, boolean expectDownload) {
        this.fileServer.setLogger(this.getLogger());
        this.fileServer.setFile(this.fileHandler, deployable.getFile());
        this.fileServer.setListeningParameters(this.deployableServerSocketAddress, this.configuration.getPropertyValue("cargo.jboss.remotedeploy.hostname"));
        try {
            this.fileServer.start();
            String encodedURL = this.encodeURLLocation(this.fileServer.getURL());
            this.invokeURL(this.createJBossRemoteURL(deployable, jmxConsoleURL, encodedURL));
            if (this.fileServer.getCallCount() == 0 && expectDownload) {
                throw new CargoException("Application server didn't request the file");
            }
        }
        catch (ContainerException e) {
            Throwable realCause;
            if (e.getCause() != null && e.getCause() instanceof SocketTimeoutException && (realCause = this.fileServer.getException()) != null) {
                throw new ContainerException("The CARGO embedded HTTP server failed", realCause);
            }
            throw e;
        }
        finally {
            this.fileServer.stop();
        }
    }

    protected InetSocketAddress buildSocketAddressForDeployableServer() {
        String addressStr;
        String portStr = this.configuration.getPropertyValue("cargo.jboss.remotedeploy.port");
        if (portStr == null) {
            portStr = "1" + this.configuration.getPropertyValue("cargo.servlet.port");
        }
        if ((addressStr = this.configuration.getPropertyValue("cargo.jboss.remotedeploy.hostname")) == null) {
            try {
                addressStr = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new CargoException("Could not get hostname for remote deployer", e);
            }
        }
        return new InetSocketAddress(addressStr, Integer.parseInt(portStr));
    }

    private void invokeURL(String url) {
        String username = this.configuration.getPropertyValue("cargo.remote.username");
        String password = this.configuration.getPropertyValue("cargo.remote.password");
        if (username == null) {
            this.getLogger().info("No remote username specified, using default [admin]", this.getClass().getName());
            username = DEFAULT_USERNAME;
        }
        if (password == null) {
            this.getLogger().info("No remote password specified, using default []", this.getClass().getName());
            password = DEFAULT_PASSWORD;
        }
        this.connection.connect(url, username, password);
    }

    private String encodeURLLocation(URL url) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(url.toExternalForm(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ContainerException("Failed to encode Deployable location [" + url + "] using an [UTF-8] encoding", e);
        }
        return encodedString;
    }

    protected String createJBossRemoteURL(Deployable deployable, String urlPrefix, String httpURL) {
        return this.configuration.getPropertyValue("cargo.protocol") + "://" + this.configuration.getPropertyValue("cargo.hostname") + ":" + this.configuration.getPropertyValue("cargo.servlet.port") + urlPrefix + httpURL;
    }
}

