/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.jboss.internal.IJBossProfileManagerDeployer;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.CargoException;

public class JBoss5xRemoteDeployer
extends AbstractRemoteDeployer {
    private IJBossProfileManagerDeployer deployer;

    public JBoss5xRemoteDeployer(RemoteContainer container) {
        String classToLoad = "org.codehaus.cargo.tools.jboss.JBossDeployer";
        StringBuilder providerURL = new StringBuilder();
        providerURL.append("jnp://");
        providerURL.append(container.getConfiguration().getPropertyValue("cargo.hostname"));
        providerURL.append(':');
        providerURL.append(container.getConfiguration().getPropertyValue("cargo.rmi.port"));
        try {
            Class<?> jbossDeployerClass = null;
            ClassLoader tcccl = Thread.currentThread().getContextClassLoader();
            if (tcccl != null) {
                try {
                    jbossDeployerClass = tcccl.loadClass("org.codehaus.cargo.tools.jboss.JBossDeployer");
                }
                catch (ClassNotFoundException e) {
                    jbossDeployerClass = null;
                }
            }
            if (jbossDeployerClass == null) {
                jbossDeployerClass = this.getClass().getClassLoader().loadClass("org.codehaus.cargo.tools.jboss.JBossDeployer");
            }
            Constructor<?> jbossDeployerConstructor = jbossDeployerClass.getConstructor(String.class);
            this.deployer = (IJBossProfileManagerDeployer)jbossDeployerConstructor.newInstance(providerURL.toString());
        }
        catch (ClassNotFoundException e) {
            throw new CargoException("Cannot locate the JBoss deployer class! Make sure the jboss-deployer for your\nJBoss version as well as all required JBoss JARs are in CARGO's classpath.\nMore information on: http://cargo.codehaus.org/JBoss+Remote+Deployer", e);
        }
        catch (Throwable t) {
            throw new CargoException("Cannot create a JBoss deployer: " + t.getMessage(), t);
        }
    }

    public void deploy(Deployable deployable) {
        File deployableFile = new File(deployable.getFile());
        try {
            this.deployer.deploy(deployableFile, deployableFile.getName());
        }
        catch (Throwable t) {
            throw new CargoException("Cannot deploy deployable " + deployable, t);
        }
    }

    public void undeploy(Deployable deployable) {
        File deployableFile = new File(deployable.getFile());
        try {
            this.deployer.undeploy(deployableFile.getName());
        }
        catch (Throwable t) {
            throw new CargoException("Cannot undeploy deployable " + deployable, t);
        }
    }

    public void redeploy(Deployable deployable) {
        try {
            this.undeploy(deployable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.deploy(deployable);
    }
}

