/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class JBossInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public JBossInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        String clustered = this.getContainer().getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(clustered).booleanValue()) {
            return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "farm");
        }
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "deploy");
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        this.getFileHandler().copyDirectory(war.getFile(), this.getFileHandler().append(deployableDir, war.getContext() + ".war"));
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void undeploy(Deployable deployable) {
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            this.undeployFile(this.getDeployableDir(), war.getContext() + ".war");
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            this.undeployFile(this.getDeployableDir(), ear.getName() + ".ear");
        } else if (deployable.getType() == DeployableType.FILE || deployable.getType() == DeployableType.SAR) {
            String fileName = this.getFileHandler().getName(deployable.getFile());
            this.undeployFile(this.getDeployableDir(), fileName);
        } else {
            super.undeploy(deployable);
            return;
        }
    }

    private boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    private void undeployFile(String directory, String file) {
        String fileName = this.getFileHandler().append(directory, file);
        if (this.fileExists(fileName)) {
            this.getLogger().info("Undeploying [" + fileName + "]...", this.getClass().getName());
            this.getFileHandler().delete(fileName);
        } else {
            this.getLogger().info("Couldn't not find file to undeploy [" + fileName + "]", this.getClass().getName());
        }
    }
}

