/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalDeployer;

public class Jetty6xEmbeddedLocalDeployer
extends AbstractJettyEmbeddedLocalDeployer {
    private Class webAppContextClass;

    public Jetty6xEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
        try {
            this.webAppContextClass = ((Jetty6xEmbeddedLocalContainer)this.getContainer()).getClassLoader().loadClass("org.mortbay.jetty.webapp.WebAppContext");
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create Jetty6xEmbeddedLocalDeployer", e);
        }
    }

    public Object deployWebApp(Deployable deployable) {
        this.getLogger().info("Deploying [" + deployable.getFile() + "]", this.getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            try {
                Jetty6xEmbeddedLocalContainer container = (Jetty6xEmbeddedLocalContainer)this.getContainer();
                Object webAppContext = container.createHandler(deployable);
                container.addHandler(webAppContext);
                String[] virtualHosts = this.getVirtualHosts();
                for (int i = 0; virtualHosts != null && i < virtualHosts.length; ++i) {
                    this.webAppContextClass.getMethod("setVirtualHosts", virtualHosts.getClass()).invoke(webAppContext, virtualHosts[i]);
                }
                if (this.getExtractWar() != null) {
                    this.webAppContextClass.getMethod("setExtractWAR", Boolean.TYPE).invoke(webAppContext, this.getExtractWar());
                }
                if (this.getCopyWebApp() != null) {
                    this.webAppContextClass.getMethod("setCopyDir", Boolean.TYPE).invoke(webAppContext, this.getCopyWebApp());
                }
                if (this.getParentLoaderPriority() != null) {
                    this.webAppContextClass.getMethod("setParentLoaderPriority", Boolean.TYPE).invoke(webAppContext, this.getParentLoaderPriority());
                }
                return webAppContext;
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", e);
            }
        }
        throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
    }

    public void undeployWebApp(Deployable deployable) {
        this.stop(deployable);
        Jetty6xEmbeddedLocalContainer container = (Jetty6xEmbeddedLocalContainer)this.getContainer();
        Object deployedWebAppContext = Jetty6xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
        try {
            container.removeHandler(deployedWebAppContext);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "]", e);
        }
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void start(Deployable deployable) {
        try {
            Object deployedWebAppContext = Jetty6xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            this.webAppContextClass.getMethod("start", null).invoke(deployedWebAppContext, null);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start [" + deployable.getFile() + "]", e);
        }
    }

    public void stop(Deployable deployable) {
        try {
            Object deployedWebAppContext = Jetty6xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            this.webAppContextClass.getMethod("stop", null).invoke(deployedWebAppContext, null);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop [" + deployable.getFile() + "]", e);
        }
    }
}

