/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6xInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public Jetty6xInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    protected void deployWar(String deployableDir, WAR war) {
        super.deployWar(deployableDir, war);
        String contextDir = this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "contexts");
        String contextFile = this.getFileHandler().append(contextDir, war.getContext() + ".xml");
        this.getFileHandler().createFile(contextFile);
        OutputStream out = this.getFileHandler().getOutputStream(contextFile);
        try {
            out.write(("<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure//EN\" \"http://jetty.mortbay.org/configure.dtd\">\n<Configure class=\"org.mortbay.jetty.webapp.WebAppContext\">\n  <Array id=\"plusConfig\" type=\"java.lang.String\">\n    <Item>org.mortbay.jetty.webapp.WebInfConfiguration</Item>\n    <Item>org.mortbay.jetty.plus.webapp.EnvConfiguration</Item>\n    <Item>org.mortbay.jetty.plus.webapp.Configuration</Item>\n    <Item>org.mortbay.jetty.webapp.JettyWebXmlConfiguration</Item>\n    <Item>org.mortbay.jetty.webapp.TagLibConfiguration</Item>\n  </Array>\n  <Set name=\"contextPath\">/" + war.getContext() + "</Set>\n" + "  <Set name=\"war\"><SystemProperty name=\"config.home\" " + "default=\".\"/>/webapps/" + war.getContext() + ".war</Set>\n" + "  <Set name=\"extractWAR\">true</Set>\n" + "  <Set name=\"defaultsDescriptor\"><SystemProperty name=\"config.home\" " + "default=\".\"/>/etc/webdefault.xml</Set>\n" + "  <Set name=\"ConfigurationClasses\"><Ref id=\"plusConfig\"/></Set>\n" + "</Configure>").getBytes());
            out.close();
        }
        catch (IOException e) {
            throw new ContainerException("Failed to create Jetty Context file for [" + war.getFile() + "]");
        }
    }
}

