/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public class Jetty7xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "jetty7x";
    private ContainerCapability capability = new ServletContainerCapability();

    public Jetty7xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public final String getId() {
        return ID;
    }

    public final String getName() {
        return "Jetty 7.x";
    }

    public final void doStart(Java java) throws Exception {
        this.invoke(java, true);
    }

    public final void doStop(Java java) throws Exception {
        this.invoke(java, false);
    }

    private void invoke(Java java, boolean isGettingStarted) throws Exception {
        Path classpath = java.createClasspath();
        this.addToolsJarToClasspath(classpath);
        if (this.getConfiguration().getPropertyValue("cargo.logging") != null && this.getConfiguration().getPropertyValue("cargo.logging").equals("high")) {
            java.addSysproperty(this.getAntUtils().createSysProperty("DEBUG", "true"));
        }
        java.addSysproperty(this.getAntUtils().createSysProperty("jetty.home", this.getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("STOP.PORT", this.getConfiguration().getPropertyValue("cargo.rmi.port")));
        java.addSysproperty(this.getAntUtils().createSysProperty("STOP.KEY", "secret"));
        java.addSysproperty(this.getAntUtils().createSysProperty("jetty.port", this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        java.addSysproperty(this.getAntUtils().createSysProperty("config.home", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jetty.logs", this.getFileHandler().append(this.getConfiguration().getHome(), "logs")));
        java.setJar(new File(this.getHome(), "start.jar"));
        if (isGettingStarted) {
            if (this.getConfiguration().getPropertyValue("cargo.runtime.args") == null) {
                StringBuilder options = new StringBuilder("OPTIONS=Server");
                File jspLib = new File(this.getHome(), "lib/jsp");
                if (jspLib.isDirectory()) {
                    options.append(",jsp");
                } else {
                    this.getLogger().warn("JSP librairies not found in " + jspLib + ", JSP support will be disabled", this.getClass().getName());
                }
                options.append(",jmx,resources,websocket,ext");
                java.createArg().setValue(options.toString());
                java.createArg().setValue("--ini");
                java.createArg().setValue(this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty.xml"));
                java.createArg().setValue("path=" + java.getCommandLine().getClasspath());
            }
        } else {
            java.createArg().setValue("--stop");
        }
        AntContainerExecutorThread jettyRunner = new AntContainerExecutorThread(java);
        this.getLogger().info("Running Jetty As: " + java.getCommandLine(), this.getClass().getName());
        jettyRunner.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        super.waitForCompletion(waitForStarting);
        if (!waitForStarting) {
            Thread.sleep(10000L);
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }
}

