/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.Jetty7xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.Jetty7xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public class Jetty7xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Jetty7xStandaloneLocalConfigurationCapability();

    public Jetty7xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "8079");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createFilterChain();
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        String sessionContextParam = "";
        if (sessionPath != null) {
            sessionContextParam = "  <context-param>\n    <param-name>org.eclipse.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n" + "  </context-param>\n";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jetty.session.path.context-param", sessionContextParam);
        String etcDir = this.getFileHandler().createDirectory(this.getHome(), "etc");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/jetty.xml", new File(etcDir, "jetty.xml"));
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/webdefault.xml", new File(etcDir, "webdefault.xml"), filterChain);
        String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        this.getFileHandler().createDirectory(this.getHome(), "contexts");
        Jetty7xInstalledLocalDeployer deployer = new Jetty7xInstalledLocalDeployer((InstalledLocalContainer)container);
        deployer.setShouldDeployExpandedWARs(true);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
    }

    public String toString() {
        return "Jetty 7.x Standalone Configuration";
    }
}

