/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import java.io.File;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jonas.internal.AbstractJonasRemoteDeployer;

public abstract class AbstractJonas4xRemoteDeployer
extends AbstractJonasRemoteDeployer {
    public AbstractJonas4xRemoteDeployer(RemoteContainer container) {
        super(container);
    }

    protected String getOperationName(AbstractJonasRemoteDeployer.ActionType actionType, DeployableType deployableType, AbstractJonasRemoteDeployer.TargetType targetType) {
        String operationSuffix;
        String operationPrefix;
        if (actionType == AbstractJonasRemoteDeployer.ActionType.DEPLOY) {
            operationPrefix = "deploy";
        } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UPLOAD_DEPLOY) {
            operationPrefix = "uploadDeploy";
        } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UNDEPLOY) {
            operationPrefix = "unDeploy";
        } else {
            throw new IllegalArgumentException("Unsupported Action type: " + actionType);
        }
        if (deployableType == DeployableType.WAR) {
            operationSuffix = "War";
        } else if (deployableType == DeployableType.EAR) {
            operationSuffix = "Ear";
        } else if (deployableType == DeployableType.EJB) {
            operationSuffix = "Jar";
        } else if (deployableType == DeployableType.RAR) {
            operationSuffix = "Rar";
        } else {
            throw new IllegalArgumentException("Unsupported Deployable type: " + deployableType);
        }
        return operationPrefix + operationSuffix;
    }

    protected String getRemoteFileName(Deployable deployable, String deployableIdentifier, boolean askFromServer) {
        String deployableId = deployableIdentifier;
        if (deployableId != null && deployableId.trim().length() > 0) {
            int identifierExtIndex = deployableId.lastIndexOf(".");
            if (identifierExtIndex != -1) {
                deployableId = deployableId.substring(0, identifierExtIndex);
            }
            if (deployable.getType() == DeployableType.WAR) {
                deployableId = deployableId + ".war";
            } else if (deployable.getType() == DeployableType.EAR) {
                deployableId = deployableId + ".ear";
            } else if (deployable.getType() == DeployableType.EJB) {
                deployableId = deployableId + ".jar";
            } else if (deployable.getType() == DeployableType.RAR) {
                deployableId = deployableId + ".rar";
            } else {
                throw new IllegalArgumentException("Unsupported Deployable type: " + deployable.getType());
            }
            return deployableId;
        }
        File localFile = new File(deployable.getFile());
        String remoteFilePath = localFile.getName();
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            remoteFilePath = war.getContext().length() == 0 ? "rootContext.war" : war.getContext() + ".war";
        }
        return remoteFilePath;
    }
}

