/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jonas.internal.JonasExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;

public abstract class AbstractJonasExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new JonasExistingLocalConfigurationCapability();
    private String toString;

    public AbstractJonasExistingLocalConfiguration(String dir, String version) {
        super(dir);
        this.setProperty("cargo.protocol", "http");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "9000");
        this.setProperty("cargo.jonas.server.name", "jonas");
        this.setProperty("cargo.jonas.domain.name", "jonas");
        this.toString = "JOnAS " + version + " Existing Local Configuration";
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void checkDirExists(String dir) {
        String path = this.getFileHandler().append(this.getHome(), dir);
        boolean exists = this.getFileHandler().exists(path);
        if (!exists) {
            throw new ContainerException("Invalid existing configuration: directory [" + path + "] does not exist in JONAS_BASE");
        }
    }

    public String toString() {
        return this.toString;
    }
}

