/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion.internal;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.orion.internal.OrionConfigurationBuilder;
import org.codehaus.cargo.container.orion.internal.OrionStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;

public abstract class AbstractOrionStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder {
    public static final String XML_PARENT_OF_RESOURCES = "//data-sources";
    private static final String ORION_RESOURCE_PATH = "/org/codehaus/cargo/container/internal/resources/oc4j9x10x";
    private static ConfigurationCapability capability = new OrionStandaloneLocalConfigurationCapability();

    public AbstractOrionStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "25791");
    }

    protected String getOrCreateResourceConfigurationFile(Resource resource, LocalContainer container) {
        throw new UnsupportedOperationException("Orion does not support configuration of arbitrary resources into the JNDI tree.");
    }

    protected String getXpathForResourcesParent() {
        throw new UnsupportedOperationException("Orion does not support configuration of arbitrary resources into the JNDI tree.");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new OrionConfigurationBuilder();
    }

    public String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "data-sources.xml");
    }

    protected Map getNamespaces() {
        return Collections.EMPTY_MAP;
    }

    protected String getXpathForDataSourcesParent() {
        return XML_PARENT_OF_RESOURCES;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createOrionFilterChain();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/server.xml", this.getFileHandler().append(confDir, "server.xml"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/application.xml", this.getFileHandler().append(confDir, "application.xml"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/default-web-site.xml", this.getFileHandler().append(confDir, "default-web-site.xml"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/mime.types", this.getFileHandler().append(confDir, "mime.types"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/principals.xml", this.getFileHandler().append(confDir, "principals.xml"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/rmi.xml", this.getFileHandler().append(confDir, "rmi.xml"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/data-sources.xml", this.getFileHandler().append(confDir, "data-sources.xml"), this.getFileHandler(), filterChain);
        this.copyCustomResources(confDir, filterChain);
        String defaultWebAppDir = this.getFileHandler().createDirectory(this.getHome(), "default-web-app/WEB-INF");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/oc4j9x10x/web.xml", this.getFileHandler().append(defaultWebAppDir, "web.xml"), this.getFileHandler(), filterChain);
        this.getFileHandler().createDirectory(this.getHome(), "persistence");
        String appDir = this.getFileHandler().createDirectory(this.getHome(), "applications");
        this.getFileHandler().createDirectory(this.getHome(), "application-deployments");
        this.getFileHandler().createDirectory(this.getHome(), "log");
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() == DeployableType.WAR && (deployable.getType() != DeployableType.WAR || ((WAR)deployable).isExpandedWar())) continue;
            fileUtils.copyFile(new File(deployable.getFile()).getAbsoluteFile(), new File(appDir, new File(deployable.getFile()).getName()), null, true);
        }
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(appDir, "cargocpc.war"), this.getFileHandler());
    }

    protected abstract void copyCustomResources(String var1, FilterChain var2) throws Exception;

    private FilterChain createOrionFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.users", this.getUserToken());
            this.getAntUtils().addTokenToFilterChain(filterChain, "orion.roles", this.getRoleToken());
        }
        ReplaceTokens.Token tokenApplications = new ReplaceTokens.Token();
        tokenApplications.setKey("orion.application");
        ReplaceTokens.Token tokenWebModules = new ReplaceTokens.Token();
        tokenWebModules.setKey("orion.web-module");
        ReplaceTokens.Token tokenWebApps = new ReplaceTokens.Token();
        tokenWebApps.setKey("orion.web-app");
        StringBuilder keyApplications = new StringBuilder(" ");
        StringBuilder keyWebModules = new StringBuilder(" ");
        StringBuilder keyWebApps = new StringBuilder(" ");
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() == DeployableType.EAR) {
                keyApplications.append("  <application name=\"");
                keyApplications.append(((EAR)deployable).getName());
                keyApplications.append("\" path=\"../applications/");
                keyApplications.append(new File(deployable.getFile()).getName());
                keyApplications.append("\"/>");
                Iterator itContexts = ((EAR)deployable).getWebContexts();
                while (itContexts.hasNext()) {
                    String webContext = (String)itContexts.next();
                    keyWebApps.append("<web-app application=\"");
                    keyWebApps.append(((EAR)deployable).getName());
                    keyWebApps.append("\" name=\"");
                    String name = ((EAR)deployable).getWebUri(webContext);
                    int warIndex = name.toLowerCase().lastIndexOf(".war");
                    if (warIndex >= 0) {
                        name = name.substring(0, warIndex);
                    }
                    keyWebApps.append(name);
                    keyWebApps.append("\" root=\"/");
                    keyWebApps.append(webContext);
                    keyWebApps.append("\"/>");
                }
                continue;
            }
            if (deployable.getType() != DeployableType.WAR) continue;
            keyWebModules.append("  <web-module id=\"");
            keyWebModules.append(((WAR)deployable).getContext());
            if (((WAR)deployable).isExpandedWar()) {
                keyWebModules.append("\" path=\"");
                keyWebModules.append(deployable.getFile());
            } else {
                keyWebModules.append("\" path=\"../applications/");
                keyWebModules.append(this.getFileHandler().getName(deployable.getFile()));
            }
            keyWebModules.append("\"/>");
            keyWebApps.append("<web-app application=\"default\" name=\"");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\" root=\"/");
            keyWebApps.append(((WAR)deployable).getContext());
            keyWebApps.append("\"/>");
        }
        tokenApplications.setValue(keyApplications.toString());
        tokenWebModules.setValue(keyWebModules.toString());
        tokenWebApps.setValue(keyWebApps.toString());
        ReplaceTokens replaceApplications = new ReplaceTokens();
        replaceApplications.addConfiguredToken(tokenApplications);
        filterChain.addReplaceTokens(replaceApplications);
        ReplaceTokens replaceWebModules = new ReplaceTokens();
        replaceWebModules.addConfiguredToken(tokenWebModules);
        filterChain.addReplaceTokens(replaceWebModules);
        ReplaceTokens replaceWebApps = new ReplaceTokens();
        replaceWebApps.addConfiguredToken(tokenWebApps);
        filterChain.addReplaceTokens(replaceWebApps);
        return filterChain;
    }

    protected String getUserToken() {
        StringBuilder token = new StringBuilder(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            for (User user : User.parseUsers(this.getPropertyValue("cargo.servlet.users"))) {
                token.append("<user deactivated=\"false\" ");
                token.append("username=\"" + user.getName() + "\" ");
                token.append("password=\"" + user.getPassword() + "\"");
                token.append("/>");
            }
        }
        return token.toString();
    }

    protected String getRoleToken() {
        StringBuilder token = new StringBuilder(" ");
        List users = User.parseUsers(this.getPropertyValue("cargo.servlet.users"));
        Map roles = User.createRoleMap(users);
        for (String role : roles.keySet()) {
            token.append("<security-role-mapping ");
            token.append("name=\"" + role + "\">");
            for (User user : (List)roles.get(role)) {
                token.append("<user name=\"" + user.getName() + "\"/>");
            }
            token.append("</security-role-mapping>");
        }
        return token.toString();
    }
}

