/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.util.Iterator;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.property.DataSourceConverter;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractConfigurationBuilder;

public class Resin2xConfigurationBuilder
extends AbstractConfigurationBuilder {
    public static final String TRANSACTIONS_WITH_XA_OR_JCA_ONLY = "Resin only supports transactions with an XADataSource or ManagedConnectionFactory object";
    private DataSourceConverter converter = new DataSourceConverter();

    public String toConfigurationEntry(Resource resource) {
        StringBuilder resourceString = new StringBuilder();
        resourceString.append("<resource-ref>\n      <res-ref-name>" + resource.getName() + "</res-ref-name>\n");
        if (resource.getClassName() != null) {
            resourceString.append("      <res-type>" + resource.getClassName() + "</res-type>\n");
        } else {
            resourceString.append("      <res-type>" + resource.getType() + "</res-type>\n");
        }
        Iterator i = resource.getParameters().keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            resourceString.append("    <init-param ").append(key);
            resourceString.append("=\"").append(resource.getParameter(key));
            resourceString.append("\" />\n");
        }
        resourceString.append("</resource-ref>");
        return resourceString.toString();
    }

    protected String toResinConfigurationEntry(DataSource ds) {
        Resource resource = null;
        resource = "javax.sql.XADataSource".equals(ds.getConnectionType()) ? this.converter.convertToResource(ds, "javax.sql.XADataSource", "driver-name") : this.converter.convertToResource(ds, "javax.sql.DataSource", "driver-name");
        return this.toConfigurationEntry(resource);
    }

    public String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource ds) {
        return this.toResinConfigurationEntry(ds);
    }

    public String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource ds) {
        throw new UnsupportedOperationException(TRANSACTIONS_WITH_XA_OR_JCA_ONLY);
    }

    public String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource ds) {
        throw new UnsupportedOperationException(TRANSACTIONS_WITH_XA_OR_JCA_ONLY);
    }

    public String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource ds) {
        return this.toResinConfigurationEntry(ds);
    }
}

