/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.packager;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractDirectoryPackager
extends LoggedObject
implements Packager {
    private String targetDirectory;
    private FileHandler fileHandler = new DefaultFileHandler();

    public AbstractDirectoryPackager(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void packageContainer(InstalledLocalContainer container) {
        this.getFileHandler().copyDirectory(container.getHome(), this.getTargetDirectory(), this.getDistributionExclusions());
        List configurationExclusions = this.getDefaultConfigurationExclusions();
        configurationExclusions.addAll(this.getConfigurationExclusions());
        this.getFileHandler().copyDirectory(container.getConfiguration().getHome(), this.getTargetDirectory(), configurationExclusions);
    }

    private List getDefaultConfigurationExclusions() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/cargocpc.war");
        return excludes;
    }

    protected abstract List getDistributionExclusions();

    protected abstract List getConfigurationExclusions();
}

