/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractCatalinaInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private ContainerCapability capability = new ServletContainerCapability();
    private String version;

    public AbstractCatalinaInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile catalinaJar = new JarFile(new File(this.getHome(), "server/lib/catalina.jar"));
                ZipEntry entry = catalinaJar.getEntry("org/apache/catalina/util/ServerInfo.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(catalinaJar.getInputStream(entry));
                    String serverInfo = props.getProperty("server.info");
                    int slashPos = serverInfo.indexOf(47);
                    if (slashPos > 0) {
                        version = serverInfo.substring(slashPos + 1);
                    }
                } else {
                    version = "4.0.x";
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find Tomcat version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().debug("Parsed Tomcat version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void doStart(Java java) throws Exception {
        this.invokeContainer("start", java);
    }

    public void doStop(Java java) throws Exception {
        this.invokeContainer("stop", java);
    }

    protected void invokeContainer(String action, Java java) throws Exception {
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.home", this.getFileHandler().getAbsolutePath(this.getHome())));
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.base", this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome())));
        File tempFile = new File(this.getConfiguration().getHome(), "temp");
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", this.getFileHandler().getAbsolutePath(tempFile.getAbsolutePath())));
        Path classpath = java.getCommandLine().getClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "bin/bootstrap.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.apache.catalina.startup.Bootstrap");
        java.createArg().setValue(action);
        AntContainerExecutorThread catalinaRunner = new AntContainerExecutorThread(java);
        catalinaRunner.start();
    }
}

