/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;
import org.codehaus.cargo.container.weblogic.WebLogic9xConfigXmlInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;
import org.codehaus.cargo.container.weblogic.internal.WebLogic9x10xAnd103xConfigurationBuilder;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.util.Dom4JUtil;
import org.codehaus.cargo.util.FileHandler;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebLogic9xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
implements WebLogicConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();
    private Dom4JUtil xmlTool;
    private HashMap namespaces;

    public WebLogic9xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
        this.setProperty("cargo.weblogic.configuration.version", "9.2.3.0");
        this.setProperty("cargo.weblogic.domain.version", "9.2.3.0");
        this.setProperty("cargo.servlet.port", "7001");
        this.setProperty("cargo.hostname", "localhost");
        this.namespaces = new HashMap();
        this.namespaces.put("weblogic", "http://www.bea.com/ns/weblogic/920/domain");
        this.namespaces.put("jdbc", "http://www.bea.com/ns/weblogic/90");
        this.xmlTool = new Dom4JUtil();
        this.xmlTool.setNamespaces(this.namespaces);
        this.xmlTool.setFileHandler(this.getFileHandler());
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        String configDir = this.getFileHandler().createDirectory(this.getDomainHome(), "/config");
        this.getFileHandler().createDirectory(this.getDomainHome(), "/config/jdbc");
        String securityDir = this.getFileHandler().createDirectory(this.getDomainHome(), "/security");
        this.getFileHandler().createDirectory(this.getDomainHome(), ((WebLogicLocalContainer)container).getAutoDeployDirectory());
        FilterChain filterChain = this.createWebLogicFilterChain();
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/config.xml", this.getFileHandler().append(configDir, "config.xml"), this.getFileHandler(), filterChain);
        WebLogic9xConfigXmlInstalledLocalDeployer deployer = new WebLogic9xConfigXmlInstalledLocalDeployer((InstalledLocalContainer)container);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/DefaultAuthenticatorInit.ldift", this.getFileHandler().append(securityDir, "DefaultAuthenticatorInit.ldift"), this.getFileHandler(), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/SerializedSystemIni.dat", this.getFileHandler().append(securityDir, "SerializedSystemIni.dat"), this.getFileHandler());
        this.deployCargoPing((WebLogicLocalContainer)container);
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.weblogic.configuration.version", this.getPropertyValue("cargo.weblogic.configuration.version"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.weblogic.domain.version", this.getPropertyValue("cargo.weblogic.domain.version"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.weblogic.server", this.getPropertyValue("cargo.weblogic.server"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.weblogic.logging", this.getWebLogicLogLevel(this.getPropertyValue("cargo.logging")));
        return filterChain;
    }

    private String getWebLogicLogLevel(String cargoLogLevel) {
        String returnVal = "Info";
        if (cargoLogLevel != null && !cargoLogLevel.trim().equals("") && !cargoLogLevel.equalsIgnoreCase("medium")) {
            if (cargoLogLevel.equalsIgnoreCase("low")) {
                returnVal = "Warning";
            } else if (cargoLogLevel.equalsIgnoreCase("high")) {
                returnVal = "Debug";
            }
        }
        return returnVal;
    }

    protected void deployCargoPing(WebLogicLocalContainer container) throws IOException {
        String deployDir = this.getFileHandler().createDirectory(this.getDomainHome(), container.getAutoDeployDirectory());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(deployDir, "cargocpc.war"), this.getFileHandler());
    }

    public String toString() {
        return "WebLogic 9x Standalone Configuration";
    }

    public String getDomainHome() {
        return this.getHome();
    }

    protected String getXpathForDataSourcesParent() {
        return "//jdbc:jdbc-data-source";
    }

    protected Map getNamespaces() {
        return this.namespaces;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        String serverName = container.getConfiguration().getPropertyValue("cargo.weblogic.server");
        return new WebLogic9x10xAnd103xConfigurationBuilder(serverName);
    }

    protected String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        String path = this.buildDataSourceFileName(ds);
        this.createBlankDataSourceFile(path);
        this.linkDataSourceToConfigXml(ds);
        return path;
    }

    protected void linkDataSourceToConfigXml(DataSource ds) {
        Document configXml = this.readConfigXml();
        Element domain = configXml.getRootElement();
        this.addDataSourceToDomain(ds, domain);
        this.writeConfigXml(configXml);
    }

    protected void addDataSourceToDomain(DataSource ds, Element domain) {
        Element connectionPool = domain.addElement("jdbc-system-resource");
        Element name = connectionPool.addElement("name");
        name.setText(ds.getId());
        Element target = connectionPool.addElement("target");
        target.setText(this.getServerName());
        Element descriptorFileName = connectionPool.addElement("descriptor-file-name");
        descriptorFileName.setText("jdbc/" + ds.getId() + "-jdbc.xml");
    }

    protected String getServerName() {
        return this.getPropertyValue("cargo.weblogic.server");
    }

    public void writeConfigXml(Document configXml) {
        String configFile = this.getConfigXmlPath();
        this.xmlTool.saveXml(configXml, configFile);
    }

    public Document readConfigXml() {
        String configFile = this.getConfigXmlPath();
        return this.xmlTool.loadXmlFromFile(configFile);
    }

    protected void createBlankDataSourceFile(String path) {
        Document document = DocumentHelper.createDocument();
        Element dataSource = document.addElement("jdbc-data-source");
        document.setRootElement(dataSource);
        dataSource.addNamespace("", "http://www.bea.com/ns/weblogic/90");
        this.xmlTool.saveXml(document, path);
    }

    protected String getConfigXmlPath() {
        String configDir = this.getFileHandler().append(this.getDomainHome(), "config");
        String configFile = this.getFileHandler().append(configDir, "config.xml");
        return configFile;
    }

    protected String buildDataSourceFileName(DataSource ds) {
        String configDir = this.getFileHandler().append(this.getDomainHome(), "config");
        String jdbcDir = this.getFileHandler().append(configDir, "jdbc");
        String file = ds.getId() + "-jdbc.xml";
        return this.getFileHandler().append(jdbcDir, file);
    }

    public void setFileHandler(FileHandler fileHandler) {
        super.setFileHandler(fileHandler);
        this.xmlTool.setFileHandler(fileHandler);
    }

    protected String getOrCreateResourceConfigurationFile(Resource resource, LocalContainer container) {
        throw new UnsupportedOperationException("WebLogic does not support configuration of arbitrary resources into the JNDI tree.");
    }

    protected String getXpathForResourcesParent() {
        throw new UnsupportedOperationException("WebLogic does not support configuration of arbitrary resources into the JNDI tree.");
    }
}

