/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;
import org.codehaus.cargo.container.weblogic.WebLogic8xConfigXmlInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;
import org.codehaus.cargo.container.weblogic.internal.WebLogic8xConfigurationBuilder;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;

public class WebLogicStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
implements WebLogicConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();

    public WebLogicStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/config.xml", this.getFileHandler().append(this.getDomainHome(), "config.xml"), this.getFileHandler(), this.getFilterChain());
        WebLogic8xConfigXmlInstalledLocalDeployer deployer = new WebLogic8xConfigXmlInstalledLocalDeployer(container);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/DefaultAuthenticatorInit.ldift", this.getFileHandler().append(this.getDomainHome(), "DefaultAuthenticatorInit.ldift"), this.getFileHandler(), this.getFilterChain());
        this.deployCargoPing((WebLogicLocalContainer)container);
    }

    protected void deployCargoPing(WebLogicLocalContainer container) throws IOException {
        String deployDir = this.getFileHandler().createDirectory(this.getDomainHome(), container.getAutoDeployDirectory());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(deployDir, "cargocpc.war"), this.getFileHandler());
    }

    public String toString() {
        return "WebLogic Standalone Configuration";
    }

    public String getDomainHome() {
        return this.getHome();
    }

    protected String getXpathForDataSourcesParent() {
        return "//Domain";
    }

    protected Map getNamespaces() {
        return Collections.EMPTY_MAP;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        String serverName = container.getConfiguration().getPropertyValue("cargo.weblogic.server");
        return new WebLogic8xConfigurationBuilder(serverName);
    }

    protected String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getFileHandler().append(this.getHome(), "config.xml");
    }

    protected String getOrCreateResourceConfigurationFile(Resource resource, LocalContainer container) {
        throw new UnsupportedOperationException("WebLogic does not support configuration of arbitrary resources into the JNDI tree.");
    }

    protected String getXpathForResourcesParent() {
        throw new UnsupportedOperationException("WebLogic does not support configuration of arbitrary resources into the JNDI tree.");
    }
}

