/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultContainerFactory
extends AbstractIntrospectionGenericHintFactory
implements ContainerFactory {
    public DefaultContainerFactory() {
        this(null);
    }

    public DefaultContainerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public boolean isContainerRegistered(String containerId, ContainerType containerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public void registerContainer(String containerId, ContainerType containerType, Class containerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClass);
    }

    public void registerContainer(String containerId, ContainerType containerType, String containerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClassName);
    }

    public Class getContainerClass(String containerId, ContainerType containerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public Container createContainer(String containerId, ContainerType containerType, Configuration configuration) {
        ContainerFactoryParameters parameters = new ContainerFactoryParameters();
        parameters.configuration = configuration;
        return (Container)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), parameters, "container");
    }

    protected Constructor getConstructor(Class containerClass, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        ContainerType type = ContainerType.toType(containerType);
        if (type.isLocal()) {
            constructor = containerClass.getConstructor(LocalConfiguration.class);
        } else if (type.isRemote()) {
            constructor = containerClass.getConstructor(RuntimeConfiguration.class);
        } else {
            throw new ContainerException("Unknown container type [" + type.getType() + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Configuration configuration = ((ContainerFactoryParameters)parameters).configuration;
        try {
            return constructor.newInstance(configuration);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage() + ", configuration " + configuration.getClass(), t);
        }
    }

    public Map getContainerIds() {
        HashMap containerIds = new HashMap();
        for (RegistrationKey key : this.getMappings().keySet()) {
            Set<ContainerType> hints;
            SimpleContainerIdentity identity = (SimpleContainerIdentity)key.getContainerIdentity();
            if (containerIds.containsKey(identity.getId())) {
                hints = (Set)containerIds.get(identity.getId());
                hints.add(ContainerType.toType(key.getHint()));
                continue;
            }
            hints = new HashSet<ContainerType>();
            hints.add(ContainerType.toType(key.getHint()));
            containerIds.put(identity.getId(), hints);
        }
        return containerIds;
    }

    private static class ContainerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Configuration configuration;

        private ContainerFactoryParameters() {
        }
    }
}

