/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.configuration;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.internal.util.FullContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public class DefaultConfigurationFactory
extends AbstractIntrospectionGenericHintFactory
implements ConfigurationFactory {
    private FileHandler fileHandler = new DefaultFileHandler();

    public DefaultConfigurationFactory() {
        this(null);
    }

    public DefaultConfigurationFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public boolean isConfigurationRegistered(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.hasMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, Class configurationClass) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClass);
    }

    public void registerConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String configurationClassName) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), configurationClassName);
    }

    public Class getConfigurationClass(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.getMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()));
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType) {
        return this.createConfiguration(containerId, containerType, configurationType, null);
    }

    public Configuration createConfiguration(String containerId, ContainerType containerType, ConfigurationType configurationType, String home) {
        ConfigurationFactoryParameters parameters = new ConfigurationFactoryParameters();
        parameters.home = home;
        return (Configuration)this.createImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationType.getType()), parameters, "configuration");
    }

    protected Constructor getConstructor(Class configurationClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        if (ConfigurationType.toType(hint) == ConfigurationType.RUNTIME) {
            constructor = configurationClass.getConstructor(new Class[0]);
        } else if (ConfigurationType.toType(hint) == ConfigurationType.EXISTING || ConfigurationType.toType(hint) == ConfigurationType.STANDALONE) {
            constructor = configurationClass.getConstructor(String.class);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Object instance;
        String home = ((ConfigurationFactoryParameters)parameters).home;
        if (ConfigurationType.toType(hint) == ConfigurationType.RUNTIME) {
            if (home != null) {
                throw new ContainerException("The configuration home parameter should not be specified for runtime configurations");
            }
            instance = constructor.newInstance(new Object[0]);
        } else if (ConfigurationType.toType(hint) == ConfigurationType.EXISTING || ConfigurationType.toType(hint) == ConfigurationType.STANDALONE) {
            if (home == null) {
                if (ConfigurationType.toType(hint) == ConfigurationType.EXISTING) {
                    throw new ContainerException("The configuration home parameter must be specified for existing configurations");
                }
                home = this.fileHandler.getTmpPath("conf");
            }
            instance = constructor.newInstance(home);
        } else {
            throw new ContainerException("Unknown configuration type [" + hint + "]");
        }
        return instance;
    }

    private static class ConfigurationFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String home;

        private ConfigurationFactoryParameters() {
        }
    }
}

