/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Identifier;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class AbstractDescriptor
extends Document
implements Descriptor {
    private DescriptorType descriptorType;

    public AbstractDescriptor(Element rootElement, DescriptorType descriptorType) {
        super(rootElement);
        if (descriptorType == null) {
            throw new NullPointerException();
        }
        this.descriptorType = descriptorType;
    }

    public Document getDocument() {
        return this;
    }

    public List getTags(DescriptorTag tag) {
        return this.getRootElement().getChildren(tag.getTagName(), tag.getTagNamespace());
    }

    public List getTags(String tagName) {
        return this.getTags(this.getDescriptorType().getTagByName(tagName));
    }

    public Iterator getElements(DescriptorTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag must not be null");
        }
        return this.getChildElements(this.getRootElement(), tag, new ArrayList()).iterator();
    }

    public Iterator getElements(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("tagName must not be null");
        }
        return this.getElements(this.getDescriptorType().getTagByName(tagName));
    }

    private List getChildElements(Element element, DescriptorTag tag, List items) {
        if (element == null || tag == null || items == null) {
            throw new IllegalArgumentException("Cannot pass null values to getChildElements");
        }
        items.addAll(element.getChildren(tag.getTagName(), tag.getTagNamespace()));
        for (Element e2 : element.getChildren()) {
            this.getChildElements(e2, tag, items);
        }
        return items;
    }

    protected void checkElement(Element element, DescriptorTag expectedTag) throws IllegalArgumentException {
        if (!expectedTag.getTagName().equals(element.getName())) {
            throw new IllegalArgumentException("Not a [" + expectedTag + "] element");
        }
    }

    protected Iterator getNestedElements(Element parent, DescriptorTag tag) {
        ArrayList elements = new ArrayList();
        List nodeList = parent.getChildren(tag.getTagName(), tag.getTagNamespace());
        for (int i = 0; i < nodeList.size(); ++i) {
            elements.add(nodeList.get(i));
        }
        return elements.iterator();
    }

    protected Element createNestedText(DescriptorTag tag, String text) {
        Element element = new Element(tag.getTagName(), tag.getTagNamespace());
        element.setText(text);
        return element;
    }

    protected String getNestedText(Element parent, DescriptorTag tag) {
        String text = null;
        List nestedElements = parent.getChildren(tag.getTagName(), tag.getTagNamespace());
        if (nestedElements.size() > 0) {
            text = this.getText((Element)nestedElements.get(0));
        }
        return text;
    }

    protected String getText(Element element) {
        return element.getText();
    }

    protected Element getImmediateChild(Element parent, DescriptorTag tag) {
        Element e = null;
        List nl = parent.getChildren();
        for (int i = 0; i < nl.size(); ++i) {
            Element n = (Element)nl.get(i);
            if (!n.getName().equals(tag.getTagName())) continue;
            e = n;
        }
        return e;
    }

    protected String getChildText(Element parent, DescriptorTag tag) {
        String text = null;
        Element e = this.getImmediateChild(parent, tag);
        if (e != null) {
            text = this.getText(e);
        }
        return text;
    }

    protected String getChildText(Element parent, String tagName) {
        return this.getChildText(parent, this.getDescriptorType().getTagByName(tagName));
    }

    public Element addElement(DescriptorTag tag, Element child, Element parent) {
        Element importedNode = (Element)child.detach();
        Element refNode = this.getInsertionPointFor(tag, parent.getName());
        int idx = parent.getContent().indexOf(refNode);
        if (idx == -1) {
            parent.addContent((Content)importedNode);
        } else {
            while (idx > 0 && parent.getContent(idx - 1) instanceof Comment) {
                --idx;
            }
            parent.addContent(idx, (Content)importedNode);
        }
        return importedNode;
    }

    protected Element getInsertionPointFor(DescriptorTag tag, String parent) {
        List elementOrder = this.getDescriptorType().getGrammar().getElementOrder(parent);
        for (int i = 0; i < elementOrder.size(); ++i) {
            DescriptorTag orderTag = (DescriptorTag)elementOrder.get(i);
            if (!orderTag.equals(tag)) continue;
            for (int j = i + 1; j < elementOrder.size(); ++j) {
                DescriptorTag theTag = (DescriptorTag)elementOrder.get(j);
                List elements = this.getRootElement().getChildren(theTag.getTagName(), theTag.getTagNamespace());
                if (elements.size() <= 0) continue;
                Element result = (Element)elements.get(0);
                return result;
            }
            break;
        }
        return null;
    }

    public DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    public Element getTagByIdentifier(DescriptorTag tag, String value) {
        if (value == null || tag == null) {
            throw new NullPointerException();
        }
        Identifier id = tag.getIdentifier();
        if (id != null) {
            List tags = this.getTags(tag);
            for (Element e : tags) {
                if (!value.equals(id.getIdentifier(e))) continue;
                return e;
            }
        }
        return null;
    }

    public Element getTagByIdentifier(String tagName, String value) {
        return this.getTagByIdentifier(this.getDescriptorType().getTagByName(tagName), value);
    }
}

