/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb.orion;

import java.util.Iterator;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.ejb.EjbDef;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.codehaus.cargo.module.ejb.orion.OrionEjbJarXmlType;
import org.jdom.Element;

public class OrionEjbJarXml
extends AbstractDescriptor
implements VendorEjbDescriptor {
    public OrionEjbJarXml(Element document, DescriptorType type) {
        super(document, type);
    }

    public String getFileName() {
        return "orion-ejb-jar.xml";
    }

    public String getJndiName(EjbDef ejb) {
        String jndiName = null;
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement != null) {
            if (ejb.getLocal() != null) {
                jndiName = ejbElement.getAttribute("local-location").getValue();
            }
            if (jndiName == null) {
                jndiName = ejbElement.getAttribute("location").getValue();
            }
        }
        return jndiName;
    }

    private Element getEjb(String ejbName) {
        Element ejbElement = this.getSessionEjb(ejbName);
        if (ejbElement == null) {
            ejbElement = this.getEntityEjb(ejbName);
        }
        return ejbElement;
    }

    private Element getSessionEjb(String ejbName) {
        Element ejbElement = null;
        Iterator names = this.getElements(new DescriptorTag(OrionEjbJarXmlType.getInstance(), "session-deployment", true));
        while (names.hasNext()) {
            Element deploymentElement = (Element)names.next();
            String name = deploymentElement.getAttribute("name").getValue();
            if (!name.equals(ejbName)) continue;
            ejbElement = deploymentElement;
            break;
        }
        return ejbElement;
    }

    private Element getEntityEjb(String ejbName) {
        Element ejbElement = null;
        Iterator names = this.getElements(new DescriptorTag(OrionEjbJarXmlType.getInstance(), "entity-deployment", true));
        while (names.hasNext()) {
            Element deploymentElement = (Element)names.next();
            String name = deploymentElement.getAttribute("name").getValue();
            if (!name.equals(ejbName)) continue;
            ejbElement = deploymentElement;
            break;
        }
        return ejbElement;
    }
}

