/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.EnumSerializer;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.EnumValues;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;
import org.codehaus.jackson.type.JavaType;

public final class ContainerSerializers {
    private ContainerSerializers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumMapSerializer
    extends SerializerBase<EnumMap<? extends Enum<?>, ?>> {
        @Override
        public void serialize(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            EnumValues enumValues = null;
            for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
                JsonSerializer<Object> currSerializer;
                Enum<?> key = entry.getKey();
                if (enumValues == null) {
                    SerializerBase ser = (SerializerBase)provider.findValueSerializer(key.getDeclaringClass());
                    enumValues = ((EnumSerializer)ser).getEnumValues();
                }
                jgen.writeFieldName(enumValues.valueFor(key));
                Object valueElem = entry.getValue();
                if (valueElem == null) {
                    provider.getNullValueSerializer().serialize(null, jgen, provider);
                    continue;
                }
                Class<?> cc = valueElem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc);
                    prevClass = cc;
                }
                try {
                    currSerializer.serialize(valueElem, jgen, provider);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, value, entry.getKey().name());
                }
            }
            jgen.writeEndObject();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = this.createSchemaNode("object", true);
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 2) {
                JavaType enumType = TypeFactory.type(typeArgs[0]);
                JavaType valueType = TypeFactory.type(typeArgs[1]);
                ObjectNode propsNode = JsonNodeFactory.instance.objectNode();
                Class enumClass = enumType.getRawClass();
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    JsonSerializer<Object> ser = provider.findValueSerializer(valueType.getRawClass());
                    JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                    propsNode.put(provider.getConfig().getAnnotationIntrospector().findEnumValue(enumValue), schemaNode);
                }
                o.put("properties", propsNode);
            }
            return o;
        }
    }

    @Deprecated
    public static final class MapSerializer
    extends org.codehaus.jackson.map.ser.MapSerializer {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumSetSerializer
    extends SerializerBase<EnumSet<? extends Enum<?>>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            JsonSerializer<Object> enumSer = null;
            for (Enum enum_ : value) {
                if (enumSer == null) {
                    enumSer = provider.findValueSerializer(enum_.getDeclaringClass());
                }
                enumSer.serialize(enum_, jgen, provider);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.type(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IterableSerializer
    extends SerializerBase<Iterable<?>> {
        public static final IterableSerializer instance = new IterableSerializer();

        @Override
        public void serialize(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.type(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IteratorSerializer
    extends SerializerBase<Iterator<?>> {
        public static final IteratorSerializer instance = new IteratorSerializer();

        @Override
        public void serialize(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            if (value.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (value.hasNext());
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.type(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollectionSerializer
    extends SerializerBase<Collection<?>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                int i = 0;
                try {
                    do {
                        Object elem;
                        if ((elem = it.next()) == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                        } else {
                            JsonSerializer<Object> currSerializer;
                            Class<?> cc = elem.getClass();
                            if (cc == prevClass) {
                                currSerializer = prevSerializer;
                            } else {
                                prevSerializer = currSerializer = provider.findValueSerializer(cc);
                                prevClass = cc;
                            }
                            currSerializer.serialize(elem, jgen, provider);
                        }
                        ++i;
                    } while (it.hasNext());
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            JavaType javaType;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint != null && (javaType = TypeFactory.type(typeHint)) instanceof CollectionType) {
                Class componentType = ((CollectionType)javaType).getContentType().getRawClass();
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexedListSerializer
    extends SerializerBase<List<?>> {
        public static final IndexedListSerializer instance = new IndexedListSerializer();

        @Override
        public void serialize(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.size();
            if (len > 0) {
                int i;
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                try {
                    for (i = 0; i < len; ++i) {
                        JsonSerializer<Object> currSerializer;
                        Object elem = value.get(i);
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        Class<?> cc = elem.getClass();
                        if (cc == prevClass) {
                            currSerializer = prevSerializer;
                        } else {
                            prevSerializer = currSerializer = provider.findValueSerializer(cc);
                            prevClass = cc;
                        }
                        currSerializer.serialize(elem, jgen, provider);
                    }
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            JavaType javaType;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint != null && (javaType = TypeFactory.type(typeHint)) instanceof CollectionType) {
                Class componentType = ((CollectionType)javaType).getContentType().getRawClass();
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }
}

