/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRequireRoles
extends AbstractNonCacheableEnforcerRule {
    private String requiredRoles = "";
    private String validRoles = "*";

    AbstractRequireRoles() {
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject mavenProject = this.getMavenProject(helper);
        Set<String> requiredRolesSet = Collections.unmodifiableSet(this.getRolesFromString(this.requiredRoles));
        Set<String> rolesFromProject = Collections.unmodifiableSet(this.getRolesFromProject(mavenProject));
        this.checkRequiredRoles(requiredRolesSet, rolesFromProject);
        this.checkValidRoles(requiredRolesSet, rolesFromProject);
    }

    private void checkRequiredRoles(Set<String> requiredRolesSet, Set<String> rolesFromProject) throws EnforcerRuleException {
        LinkedHashSet<String> copyOfRequiredRolesSet = new LinkedHashSet<String>(requiredRolesSet);
        copyOfRequiredRolesSet.removeAll(rolesFromProject);
        if (copyOfRequiredRolesSet.size() > 0) {
            String message = String.format("Found no %s representing role(s) '%s'", this.getRoleName(), copyOfRequiredRolesSet);
            throw new EnforcerRuleException(message);
        }
    }

    private void checkValidRoles(Set<String> requiredRolesSet, Set<String> rolesFromProject) throws EnforcerRuleException {
        LinkedHashSet<String> copyOfRolesFromProject = new LinkedHashSet<String>(rolesFromProject);
        Set<String> allowedRoles = this.getRolesFromString(this.validRoles);
        if (!allowedRoles.contains("*")) {
            allowedRoles.addAll(requiredRolesSet);
            copyOfRolesFromProject.removeAll(allowedRoles);
            if (copyOfRolesFromProject.size() > 0) {
                String message = String.format("Found invalid %s role(s) '%s'", this.getRoleName(), copyOfRolesFromProject);
                throw new EnforcerRuleException(message);
            }
        }
    }

    protected abstract Set<String> getRolesFromProject(MavenProject var1);

    protected abstract String getRoleName();

    Set<String> getRolesFromString(String toSet) {
        List<String> asList = Arrays.asList(StringUtils.split((String)toSet, (String)","));
        HashSet<String> result = new HashSet<String>();
        for (String role : asList) {
            result.add(role.trim());
        }
        return result;
    }

    MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to get project.", (Exception)((Object)eee));
        }
    }

    void setRequiredRoles(String requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    void setValidRoles(String validRoles) {
        this.validRoles = validRoles;
    }
}

