/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class BanCircularDependencies
extends AbstractStandardEnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.warnIfMaven2(helper);
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            Set artifacts = project.getArtifacts();
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    log.debug((CharSequence)("groupId: " + artifact.getGroupId() + project.getGroupId()));
                    if (!artifact.getGroupId().equals(project.getGroupId())) continue;
                    log.debug((CharSequence)("artifactId: " + artifact.getArtifactId() + " " + project.getArtifactId()));
                    if (!artifact.getArtifactId().equals(project.getArtifactId())) continue;
                    StringBuilder buf = new StringBuilder(this.getErrorMessage());
                    buf.append("\n  ").append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append("\n ");
                    throw new EnforcerRuleException(buf.toString());
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            log.error((CharSequence)"Error checking for circular dependencies", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void warnIfMaven2(EnforcerRuleHelper helper) {
        Log log = helper.getLog();
        try {
            RuntimeInformation rti = (RuntimeInformation)helper.getComponent(RuntimeInformation.class);
            ArtifactVersion detectedMavenVersion = rti.getApplicationVersion();
            log.debug((CharSequence)("Detected Maven Version: " + detectedMavenVersion));
            if (detectedMavenVersion.getMajorVersion() == 2) {
                log.warn((CharSequence)"Circular dependencies cannot exist with Maven 2. So that rule is of no use for that Maven version. See rule documentation at http://mojo.codehaus.org/extra-enforcer-rules/banCircularDependencies.html");
            }
        }
        catch (ComponentLookupException e) {
            log.warn((CharSequence)"Unable to detect Maven version. Please report this issue to the mojo@codehaus project");
        }
    }

    private String getErrorMessage() {
        if (this.message == null) {
            return "Circular Dependency found. Your project's groupId:artifactId combination must not exist in the list of direct or transitive dependencies.";
        }
        return this.message;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }
}

