/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.mojo.gwt.webxml.GwtWebInfProcessor;
import org.codehaus.mojo.gwt.webxml.ServletDescriptor;

public class MakeCatalinaBase {
    private static final String GWT_DEV_SHELL = "com.google.gwt.dev.shell.GWTShellServlet";
    private File baseDir;
    private File sourceWebXml;
    private String shellServletMappingURL;

    public MakeCatalinaBase(File baseDir, File sourceWebXml, String shellServletMappingURL) {
        this.baseDir = baseDir;
        this.sourceWebXml = sourceWebXml;
        this.shellServletMappingURL = shellServletMappingURL;
    }

    public void setup() throws Exception {
        this.baseDir.mkdirs();
        File conf = new File(this.baseDir, "conf");
        conf.mkdirs();
        File gwt = new File(conf, "gwt");
        gwt.mkdirs();
        File localhost = new File(gwt, "localhost");
        localhost.mkdirs();
        File webapps = new File(this.baseDir, "webapps");
        webapps.mkdirs();
        File root = new File(webapps, "ROOT");
        root.mkdirs();
        File webinf = new File(root, "WEB-INF");
        webinf.mkdirs();
        new File(this.baseDir, "work").mkdirs();
        FileOutputStream fos = new FileOutputStream(new File(conf, "web.xml"));
        InputStream baseWebXml = this.getClass().getResourceAsStream("baseWeb.xml");
        if (baseWebXml != null) {
            IOUtils.copy((InputStream)baseWebXml, (OutputStream)fos);
        }
        File mergeWebXml = new File(webinf, "web.xml");
        if (this.sourceWebXml.exists()) {
            ServletDescriptor d = new ServletDescriptor(this.shellServletMappingURL, GWT_DEV_SHELL);
            d.setName("shell");
            Set<ServletDescriptor> servlets = Collections.singleton(d);
            new GwtWebInfProcessor().process(this.sourceWebXml, mergeWebXml, servlets);
        } else {
            fos = new FileOutputStream(mergeWebXml);
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("emptyWeb.xml"), (OutputStream)fos);
        }
    }
}

