/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jasperreports;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class JasperReportsMojo
extends AbstractMojo {
    private MavenProject project;
    private File javaDirectory;
    private File outputDirectory;
    private File sourceDirectory;
    private String sourceFileExt;
    private String outputFileExt;
    private boolean keepJava;
    private boolean keepSerializedObject;
    private boolean xmlValidation;
    private String compiler;
    private List classpathElements;
    private String additionalClasspath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("javaDir = " + this.javaDirectory));
        this.getLog().debug((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.getLog().debug((CharSequence)("sourceFileExt = " + this.sourceFileExt));
        this.getLog().debug((CharSequence)("targetDirectory = " + this.outputDirectory));
        this.getLog().debug((CharSequence)("targetFileExt = " + this.outputFileExt));
        this.getLog().debug((CharSequence)("keepJava = " + this.keepJava));
        this.getLog().debug((CharSequence)("xmlValidation = " + this.xmlValidation));
        this.getLog().debug((CharSequence)("compiler = " + this.compiler));
        this.getLog().debug((CharSequence)("classpathElements = " + this.classpathElements));
        this.getLog().debug((CharSequence)("additionalClasspath = " + this.additionalClasspath));
        this.checkDir(this.javaDirectory, "Directory for generated java sources", true);
        this.checkDir(this.sourceDirectory, "Source directory", false);
        this.checkDir(this.outputDirectory, "Target directory", true);
        JRProperties.backupProperties();
        try {
            String classpath = this.buildClasspathString(this.classpathElements, this.additionalClasspath);
            this.getLog().debug((CharSequence)("buildClasspathString() = " + classpath));
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)this.javaDirectory.getAbsolutePath());
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.keep.java.file", (boolean)this.keepJava);
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)this.compiler);
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.xml.validation", (boolean)this.xmlValidation);
            SuffixMapping mapping = new SuffixMapping(this.sourceFileExt, this.outputFileExt);
            Set staleSources = this.scanSrcDir((SourceMapping)mapping);
            if (staleSources.isEmpty()) {
                this.getLog().info((CharSequence)"Nothing to compile - all Jasper reports are up to date");
            } else {
                this.compile(staleSources, (SourceMapping)mapping);
                if (this.keepJava) {
                    this.project.addCompileSourceRoot(this.javaDirectory.getAbsolutePath());
                }
            }
        }
        finally {
            JRProperties.restoreProperties();
        }
    }

    protected void compile(Set files, SourceMapping mapping) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("Compiling " + files.size() + " report design files."));
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File src = (File)it.next();
            String srcName = this.getPathRelativeToRoot(src);
            try {
                File dest = (File)mapping.getTargetFiles(this.outputDirectory, srcName).iterator().next();
                File destFileParent = dest.getParentFile();
                if (!destFileParent.exists()) {
                    if (destFileParent.mkdirs()) {
                        this.getLog().debug((CharSequence)("Created directory " + destFileParent));
                    } else {
                        throw new MojoExecutionException("Could not create directory " + destFileParent);
                    }
                }
                this.getLog().info((CharSequence)("Compiling report file: " + srcName));
                JasperCompileManager.compileReportToFile((String)src.getAbsolutePath(), (String)dest.getAbsolutePath());
            }
            catch (JRException e) {
                throw new MojoFailureException((Object)this, "Error compiling report design : " + src, "Error compiling report design : " + src + " : " + e.getMessage());
            }
            catch (InclusionScanException e) {
                throw new MojoFailureException((Object)this, "Error compiling report design : " + src, "Error compiling report design : " + src + " : " + e.getMessage());
            }
        }
        this.getLog().info((CharSequence)("Compiled " + files.size() + " report design files."));
    }

    protected Set scanSrcDir(SourceMapping mapping) throws MojoExecutionException {
        boolean staleMillis = false;
        StaleSourceScanner scanner = new StaleSourceScanner(0L);
        scanner.addSourceMapping(mapping);
        try {
            return scanner.getIncludedSources(this.sourceDirectory, this.outputDirectory);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + this.sourceDirectory + "' " + "for stale files to recompile.", (Exception)((Object)e));
        }
    }

    private String getPathRelativeToRoot(File file) throws MojoExecutionException {
        try {
            String root = this.sourceDirectory.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (!filePath.startsWith(root)) {
                throw new MojoExecutionException("File is not in source root ??? " + file);
            }
            return filePath.substring(root.length() + 1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from file " + file, (Exception)e);
        }
    }

    protected String buildClasspathString(List classpathElements, String additionalClasspath) {
        StringBuffer classpath = new StringBuffer();
        Iterator it = classpathElements.iterator();
        while (it.hasNext()) {
            String cpElement = (String)it.next();
            classpath.append(cpElement);
            if (!it.hasNext()) continue;
            classpath.append(File.pathSeparator);
        }
        if (additionalClasspath != null) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(additionalClasspath);
        }
        return classpath.toString();
    }

    private void checkDir(File dir, String desc, boolean isTarget) throws MojoExecutionException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new MojoExecutionException(desc + " is not a directory : " + dir);
        }
        if (!dir.exists() && isTarget && !dir.mkdirs()) {
            throw new MojoExecutionException(desc + " could not be created : " + dir);
        }
        if (isTarget && !dir.canWrite()) {
            throw new MojoExecutionException(desc + " is not writable : " + dir);
        }
    }
}

