/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JTB;
import org.codehaus.mojo.javacc.JavaCC;

@Mojo(name="jtb-javacc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JTBJavaCCMojo
extends AbstractJavaCCMojo {
    @Parameter(property="javacc.packageName")
    private String packageName;
    @Parameter(property="javacc.nodePackageName")
    private String nodePackageName;
    @Parameter(property="javacc.visitorPackageName")
    private String visitorPackageName;
    @Parameter(property="javacc.supressErrorChecking")
    private Boolean supressErrorChecking;
    @Parameter(property="javacc.javadocFriendlyComments")
    private Boolean javadocFriendlyComments;
    @Parameter(property="javacc.descriptiveFieldNames")
    private Boolean descriptiveFieldNames;
    @Parameter(property="javacc.nodeParentClass")
    private String nodeParentClass;
    @Parameter(property="javacc.parentPointers")
    private Boolean parentPointers;
    @Parameter(property="javacc.specialTokens")
    private Boolean specialTokens;
    @Parameter(property="javacc.scheme")
    private Boolean scheme;
    @Parameter(property="javacc.printer")
    private Boolean printer;
    @Parameter(property="javacc.sourceDirectory", defaultValue="${basedir}/src/main/jtb")
    private File sourceDirectory;
    @Parameter(property="javacc.interimDirectory", defaultValue="${project.build.directory}/generated-sources/jtb")
    private File interimDirectory;
    @Parameter(property="javacc.outputDirectory", defaultValue="${project.build.directory}/generated-sources/javacc")
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="javacc.lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jtb", "**/*.JTB"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    @Override
    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File tempDirectory;
        File jtbFile = grammarInfo.getGrammarFile();
        File jtbDirectory = jtbFile.getParentFile();
        File jjDirectory = tempDirectory = this.getTempDirectory();
        String nodePackage = grammarInfo.resolvePackageName(this.getNodePackageName());
        File nodeDirectory = new File(tempDirectory, "node");
        String visitorPackage = grammarInfo.resolvePackageName(this.getVisitorPackageName());
        File visitorDirectory = new File(tempDirectory, "visitor");
        File parserDirectory = new File(tempDirectory, "parser");
        JTB jtb = this.newJTB();
        jtb.setInputFile(jtbFile);
        jtb.setOutputDirectory(jjDirectory);
        jtb.setNodeDirectory(nodeDirectory);
        jtb.setVisitorDirectory(visitorDirectory);
        jtb.setNodePackageName(nodePackage);
        jtb.setVisitorPackageName(visitorPackage);
        jtb.run();
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jtb.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
        this.copyGrammarOutput(this.getInterimDirectory(), nodePackage, nodeDirectory, "!Node*");
        this.copyGrammarOutput(this.getInterimDirectory(), visitorPackage, visitorDirectory, "");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), parserDirectory, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), jtbDirectory, "*");
        }
        this.deleteTempDirectory(tempDirectory);
    }

    private String getNodePackageName() {
        if (this.packageName != null) {
            return this.packageName + ".syntaxtree";
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return "*.syntaxtree";
    }

    private String getVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName + ".visitor";
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return "*.visitor";
    }

    private JTB newJTB() {
        JTB jtb = new JTB();
        jtb.setLog(this.getLog());
        jtb.setDescriptiveFieldNames(this.descriptiveFieldNames);
        jtb.setJavadocFriendlyComments(this.javadocFriendlyComments);
        jtb.setNodeParentClass(this.nodeParentClass);
        jtb.setParentPointers(this.parentPointers);
        jtb.setPrinter(this.printer);
        jtb.setScheme(this.scheme);
        jtb.setSpecialTokens(this.specialTokens);
        jtb.setSupressErrorChecking(this.supressErrorChecking);
        return jtb;
    }
}

