/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.javacc.UrlUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class ForkedJvm {
    private StreamConsumer systemOut;
    private StreamConsumer systemErr;
    private final String executable;
    private File workingDirectory;
    private final Set<String> classPathEntries = new LinkedHashSet<String>();
    private String mainClass;
    private final List<String> cmdLineArgs = new ArrayList<String>();

    public ForkedJvm() {
        this.executable = ForkedJvm.getDefaultExecutable();
    }

    private static String getDefaultExecutable() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    public void setSystemOut(StreamConsumer consumer) {
        this.systemOut = consumer;
    }

    public void setSystemErr(StreamConsumer consumer) {
        this.systemErr = consumer;
    }

    public void addClassPathEntry(String path) {
        if (path != null) {
            this.classPathEntries.add(path);
        }
    }

    public void addClassPathEntry(File path) {
        if (path != null) {
            this.classPathEntries.add(path.getAbsolutePath());
        }
    }

    public void addClassPathEntry(Class<?> type) {
        this.addClassPathEntry(ForkedJvm.getClassSource(type));
    }

    private static File getClassSource(Class<?> type) {
        if (type != null) {
            String classResource = type.getName().replace('.', '/') + ".class";
            return ForkedJvm.getResourceSource(classResource, type.getClassLoader());
        }
        return null;
    }

    private static File getClassSource(String className) {
        if (className != null) {
            String classResource = className.replace('.', '/') + ".class";
            return ForkedJvm.getResourceSource(classResource, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }

    private static File getResourceSource(String resource, ClassLoader loader) {
        if (resource != null) {
            URL url = loader != null ? loader.getResource(resource) : ClassLoader.getSystemResource(resource);
            return UrlUtils.getResourceRoot(url, resource);
        }
        return null;
    }

    public void setMainClass(String name) {
        this.mainClass = name;
        this.addClassPathEntry(ForkedJvm.getClassSource(name));
    }

    public void setMainClass(Class<?> type) {
        this.mainClass = type != null ? type.getName() : null;
        this.addClassPathEntry(type);
    }

    private String[] getArguments() {
        return this.cmdLineArgs.toArray(new String[0]);
    }

    public void addArgument(String argument) {
        if (argument != null) {
            this.cmdLineArgs.add(argument);
        }
    }

    public void addArgument(File argument) {
        if (argument != null) {
            this.cmdLineArgs.add(argument.getAbsolutePath());
        }
    }

    public void addArguments(String[] arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                this.addArgument(argument);
            }
        }
    }

    private Commandline createCommandLine() {
        String classPath;
        Commandline cli = new Commandline();
        cli.setExecutable(this.executable);
        if (this.workingDirectory != null) {
            cli.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        }
        if ((classPath = String.join((CharSequence)File.pathSeparator, this.classPathEntries)).length() > 0) {
            cli.addArguments(new String[]{"-cp", classPath});
        }
        if (this.mainClass != null && this.mainClass.length() > 0) {
            cli.addArguments(new String[]{this.mainClass});
        }
        cli.addArguments(this.getArguments());
        return cli;
    }

    public int run() throws Exception {
        return CommandLineUtils.executeCommandLine((Commandline)this.createCommandLine(), (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
    }

    public String toString() {
        return String.valueOf(this.createCommandLine());
    }
}

