/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.EnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.filters.AbstractFilter;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.FileFilterAdapter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;
import org.codehaus.mojo.jaxb2.shared.version.DependencyInfo;
import org.codehaus.mojo.jaxb2.shared.version.DependsFileParser;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractJaxbMojo
extends AbstractMojo {
    public static final String STANDARD_EPISODE_FILENAME = "sun-jaxb.episode";
    public static final String PACKAGE_INFO_FILENAME = "package-info.java";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final Pattern CONTAINS_WHITESPACE = Pattern.compile("(\\S*\\s+\\S*)+", 64);
    public static final List<Filter<File>> STANDARD_EXCLUDE_FILTERS;
    private static final List<String> RELEVANT_GROUPIDS;
    private static final String OWN_ARTIFACT_ID = "jaxb2-maven-plugin";
    private static final String SYSTEM_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String[] STANDARD_EXCLUDE_SUFFIXES;
    private static final String[] STANDARD_PRELOADED_CLASSES;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;
    @Parameter(defaultValue="${project.build.directory}/jaxb2", readonly=true, required=true)
    protected File staleFileDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(required=false)
    protected String locale;
    @Parameter(required=false)
    protected List<EnvironmentFacet> extraFacets;

    protected abstract void addResource(Resource var1);

    protected final BuildContext getBuildContext() {
        return this.getInjectedObject(this.buildContext, "buildContext");
    }

    protected final MavenProject getProject() {
        return this.getInjectedObject(this.project, "project");
    }

    public MojoExecution getExecution() {
        return this.getInjectedObject(this.execution, "execution");
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        boolean isDebugEnabled = log.isDebugEnabled();
        boolean isInfoEnabled = log.isInfoEnabled();
        if (this.shouldExecutionBeSkipped()) {
            if (isDebugEnabled) {
                log.debug((CharSequence)"Skipping execution, as instructed.");
            }
            return;
        }
        if (isDebugEnabled) {
            this.logPluginAndJaxbDependencyInfo();
        }
        if (this.isReGenerationRequired()) {
            if (this.performExecution()) {
                this.updateStaleFileTimestamp();
                this.buildContext.refresh(this.getOutputDirectory());
            } else if (isInfoEnabled) {
                log.info((CharSequence)"Not updating staleFile timestamp as instructed.");
            }
        } else if (isInfoEnabled) {
            log.info((CharSequence)"No changes detected in schema or binding files - skipping JAXB generation.");
        }
        if (this.getOutputDirectory().exists() && this.getOutputDirectory().isDirectory()) {
            String canonicalPathToOutputDirectory = FileSystemUtilities.getCanonicalPath(this.getOutputDirectory());
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Adding existing JAXB outputDirectory [" + canonicalPathToOutputDirectory + "] to Maven's sources."));
            }
            this.addGeneratedSourcesToProjectSourceRoot(canonicalPathToOutputDirectory);
        }
    }

    protected abstract void addGeneratedSourcesToProjectSourceRoot(String var1);

    protected abstract boolean shouldExecutionBeSkipped();

    protected abstract boolean isReGenerationRequired();

    protected abstract boolean performExecution() throws MojoExecutionException, MojoFailureException;

    protected abstract List<URL> getSources();

    protected abstract File getOutputDirectory();

    protected abstract List<String> getClasspath() throws MojoExecutionException;

    protected void warnAboutIncorrectPluginConfiguration(String propertyName, String description) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n+=================== [Incorrect Plugin Configuration Detected]\n");
        builder.append("|\n");
        builder.append("| Property : " + propertyName + "\n");
        builder.append("| Problem  : " + description + "\n");
        builder.append("|\n");
        builder.append("+=================== [End Incorrect Plugin Configuration Detected]\n\n");
        this.getLog().warn((CharSequence)builder.toString().replace("\n", NEWLINE));
    }

    protected final String[] logAndReturnToolArguments(String[] arguments, String toolName) {
        Validate.notNull(arguments, "arguments");
        if (this.getLog().isDebugEnabled()) {
            StringBuilder argBuilder = new StringBuilder();
            argBuilder.append("\n+=================== [" + arguments.length + " " + toolName + " Arguments]\n");
            argBuilder.append("|\n");
            for (int i = 0; i < arguments.length; ++i) {
                argBuilder.append("| [").append(i).append("]: ").append(arguments[i]).append("\n");
            }
            argBuilder.append("|\n");
            argBuilder.append("+=================== [End " + arguments.length + " " + toolName + " Arguments]\n\n");
            this.getLog().debug((CharSequence)argBuilder.toString().replace("\n", NEWLINE));
        }
        return arguments;
    }

    protected abstract String getStaleFileName();

    protected final File getStaleFile() {
        String staleFileName = "." + (this.getExecution() == null ? "nonExecutionJaxb" : this.getExecution().getExecutionId()) + "-" + this.getStaleFileName();
        return new File(this.staleFileDirectory, staleFileName);
    }

    protected final String getEncoding(boolean warnIfPlatformEncoding) {
        String effectiveEncoding;
        boolean configuredEncoding = this.encoding != null;
        String fileEncoding = System.getProperty(SYSTEM_FILE_ENCODING_PROPERTY);
        String string = effectiveEncoding = configuredEncoding ? this.encoding : fileEncoding;
        if (!configuredEncoding && warnIfPlatformEncoding) {
            this.getLog().warn((CharSequence)("Using platform encoding [" + effectiveEncoding + "], i.e. build is platform dependent!"));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using " + (configuredEncoding ? "explicitly configured" : "system property") + " encoding [" + effectiveEncoding + "]"));
        }
        return effectiveEncoding;
    }

    protected File getEpisodeFile(String episodeFileName) throws MojoExecutionException {
        File generatedJaxbEpisodeDirectory;
        Path episodePath;
        String effectiveEpisodeFileName;
        String executionID;
        String string = executionID = this.getExecution() != null && this.getExecution().getExecutionId() != null ? this.getExecution().getExecutionId() : null;
        Object object = episodeFileName == null ? (executionID == null ? STANDARD_EPISODE_FILENAME : "episode_" + executionID) : (effectiveEpisodeFileName = episodeFileName);
        if (effectiveEpisodeFileName.isEmpty()) {
            throw new MojoExecutionException("Cannot handle null or empty JAXB Episode filename. Check 'episodeFileName' configuration property.");
        }
        try {
            Path path = Paths.get(this.getOutputDirectory().getAbsolutePath(), "META-INF", "JAXB");
            episodePath = Files.createDirectories(path, new FileAttribute[0]);
            generatedJaxbEpisodeDirectory = episodePath.toFile();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Created EpisodePath [" + episodePath.toString() + "]: " + (generatedJaxbEpisodeDirectory.exists() && generatedJaxbEpisodeDirectory.isDirectory())));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create output directory.", (Exception)e);
        }
        if (!generatedJaxbEpisodeDirectory.exists() || !generatedJaxbEpisodeDirectory.isDirectory()) {
            throw new MojoExecutionException("Could not create directory [" + episodePath.toString() + "]");
        }
        File episodeFile = new File(generatedJaxbEpisodeDirectory, effectiveEpisodeFileName + ".xjb");
        AtomicInteger index = new AtomicInteger(1);
        while (episodeFile.exists()) {
            episodeFile = new File(generatedJaxbEpisodeDirectory, effectiveEpisodeFileName + "_" + index.getAndIncrement() + ".xjb");
        }
        Resource outputDirectoryResource = new Resource();
        outputDirectoryResource.setDirectory(this.getOutputDirectory().getAbsolutePath());
        outputDirectoryResource.setIncludes(Collections.singletonList("**/" + episodeFile.getName()));
        this.addResource(outputDirectoryResource);
        return episodeFile;
    }

    private void logPluginAndJaxbDependencyInfo() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n+=================== [Brief Plugin Build Dependency Information]\n");
            builder.append("|\n");
            builder.append("| Note: These dependencies pertain to what was used to build *the plugin*.\n");
            builder.append("|       Check project dependencies to see the ones used in *your build*.\n");
            builder.append("|\n");
            SortedMap<String, String> versionMap = DependsFileParser.getVersionMap(OWN_ARTIFACT_ID);
            builder.append("|\n");
            builder.append("| Plugin's own information\n");
            builder.append("|     GroupId    : " + (String)versionMap.get("groupId") + "\n");
            builder.append("|     ArtifactID : " + (String)versionMap.get("artifactId") + "\n");
            builder.append("|     Version    : " + (String)versionMap.get("version") + "\n");
            builder.append("|     Buildtime  : " + (String)versionMap.get("buildtime") + "\n");
            builder.append("|\n");
            builder.append("| Plugin's JAXB-related dependencies\n");
            builder.append("|\n");
            SortedMap<String, DependencyInfo> diMap = DependsFileParser.createDependencyInfoMap(versionMap);
            int dependencyIndex = 0;
            for (Map.Entry<String, DependencyInfo> current : diMap.entrySet()) {
                String key = current.getKey().trim();
                for (String currentRelevantGroupId : RELEVANT_GROUPIDS) {
                    if (!key.startsWith(currentRelevantGroupId)) continue;
                    DependencyInfo di = current.getValue();
                    builder.append("|   " + ++dependencyIndex + ") [" + di.getArtifactId() + "]\n");
                    builder.append("|     GroupId    : " + di.getGroupId() + "\n");
                    builder.append("|     ArtifactID : " + di.getArtifactId() + "\n");
                    builder.append("|     Version    : " + di.getVersion() + "\n");
                    builder.append("|     Scope      : " + di.getScope() + "\n");
                    builder.append("|     Type       : " + di.getType() + "\n");
                    builder.append("|\n");
                }
            }
            builder.append("+=================== [End Brief Plugin Build Dependency Information]\n\n");
            this.getLog().debug((CharSequence)builder.toString().replace("\n", NEWLINE));
        }
    }

    private <T> T getInjectedObject(T objectOrNull, String objectName) {
        if (objectOrNull == null) {
            this.getLog().error((CharSequence)("Found null '" + objectName + "', implying that Maven @Component injection was not done properly."));
        }
        return objectOrNull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateStaleFileTimestamp() throws MojoExecutionException {
        File staleFile = this.getStaleFile();
        if (!staleFile.exists()) {
            FileSystemUtilities.createDirectory(staleFile.getParentFile(), false);
            try {
                staleFile.createNewFile();
                if (!this.getLog().isDebugEnabled()) return;
                this.getLog().debug((CharSequence)("Created staleFile [" + FileSystemUtilities.getCanonicalPath(staleFile) + "]"));
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create staleFile.", (Exception)e);
            }
        } else {
            if (staleFile.setLastModified(System.currentTimeMillis())) return;
            this.getLog().warn((CharSequence)("Failed updating modification time of staleFile [" + FileSystemUtilities.getCanonicalPath(staleFile) + "]"));
        }
    }

    protected void logSystemPropertiesAndBasedir() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n+=================== [System properties]\n");
            builder.append("|\n");
            TreeMap<Object, Object> props = new TreeMap<Object, Object>();
            props.put("basedir", FileSystemUtilities.getCanonicalPath(this.getProject().getBasedir()));
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                props.put("" + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                builder.append("| [" + (String)entry.getKey() + "]: " + entry.getValue() + "\n");
            }
            builder.append("|\n");
            builder.append("+=================== [End System properties]\n");
            this.getLog().debug((CharSequence)builder.toString().replace("\n", NEWLINE));
        }
    }

    static {
        RELEVANT_GROUPIDS = Arrays.asList("com.sun.xml.bind", "jakarta.xml.bind");
        STANDARD_EXCLUDE_SUFFIXES = new String[]{"README.*", "\\.xml", "\\.txt"};
        STANDARD_PRELOADED_CLASSES = new String[]{"com.sun.tools.xjc.addon.episode.package-info", "com.sun.tools.xjc.reader.xmlschema.bindinfo.package-info", "org.glassfish.jaxb.core.v2.model.core.package-info", "org.glassfish.jaxb.runtime.v2.model.runtime.package-info", "org.glassfish.jaxb.core.v2.schemagen.episode.package-info", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.package-info"};
        ArrayList<AbstractFilter> tmp = new ArrayList<AbstractFilter>();
        tmp.add(new PatternFileFilter(Arrays.asList(STANDARD_EXCLUDE_SUFFIXES), true));
        tmp.add(new FileFilterAdapter(new FileFilter(){

            @Override
            public boolean accept(File aFileOrDir) {
                if (aFileOrDir == null) {
                    return false;
                }
                String name = aFileOrDir.getName();
                return name.startsWith(".") || aFileOrDir.isDirectory() && name.equals("CVS");
            }
        }));
        STANDARD_EXCLUDE_FILTERS = Collections.unmodifiableList(tmp);
        try {
            ClassLoader cl = AbstractJaxbMojo.class.getClassLoader();
            for (String current : STANDARD_PRELOADED_CLASSES) {
                cl.loadClass(current);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }
}

