/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jslint;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jslint.FilteredDirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJSLintMojo
extends AbstractMojo {
    private List<String> includes;
    private List<String> excludes;
    private String encoding;
    private boolean failOnIssues;
    private boolean adsafe;
    private boolean disallowBitwiseOperators;
    private boolean assumeABrowser;
    private boolean requireInitialCapsForConstructors;
    private boolean tolerateCSSWorkarounds;
    private boolean tolerateDebuggerStatements;
    private boolean assumeConsoleAlertEtc;
    private boolean tolerateContinuation;
    private boolean tolerateES5Syntax;
    private boolean tolerateEval;
    private boolean tolerateUnfilteredForIn;
    private boolean tolerateHTMLFragments;
    private boolean strictWhiteSpace;
    private Integer strictWhiteSpaceIndentation;
    private Integer maximumLengthOfLine;
    private Integer maximumNumberOfErrors;
    private boolean tolerateHTMLCase;
    private boolean disallowDanglingUnderbarInIdentifiers;
    private boolean tolerateHTMLEventHandlers;
    private boolean allowOneVarStatementPerFunction;
    private boolean stopOnFirstError;
    private boolean disallowIncrAndDecr;
    private String predefinedVars;
    private boolean disallowInsecureCharsInRegExp;
    private boolean assumeRhino;
    private boolean safeSubset;
    private boolean requireUseStrict;
    private boolean tolerateInefficientSubscripting;
    private boolean disallowUndefinedVariables;
    private boolean assumeAYahooWidget;
    private boolean assumeWindows;
    private JSLint jsLint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Issue> checkFileForIssues(File sourceFile) throws MojoExecutionException {
        List list;
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(sourceFile), this.encoding);
        BufferedReader bufferedFileReader = new BufferedReader(fileReader);
        try {
            JSLintResult result = this.jsLint.lint(sourceFile.getName(), (Reader)bufferedFileReader);
            list = result.getIssues();
        }
        catch (Throwable throwable) {
            try {
                bufferedFileReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem while parsing file: " + sourceFile.getName(), (Exception)e);
            }
        }
        bufferedFileReader.close();
        return list;
    }

    public void execute() throws MojoExecutionException {
        File lastModifiedFile = new File(this.getWorkFolder(), "lastModified");
        long modifiedSinceTime = lastModifiedFile.lastModified();
        this.initJSLint();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        long latestModificationTime = 0L;
        for (String pathOfJsFile : this.getPathsOfJsFiles(modifiedSinceTime)) {
            this.getLog().info((CharSequence)("Parsing: " + pathOfJsFile));
            File sourceFolder = this.getSourceJsFolder();
            File jsFile = new File(sourceFolder, pathOfJsFile);
            List<Issue> issuesOfFile = this.checkFileForIssues(jsFile);
            issues.addAll(issuesOfFile);
            long lastModified = jsFile.lastModified();
            if (lastModified <= latestModificationTime) continue;
            latestModificationTime = lastModified;
        }
        for (Issue issue : issues) {
            if (this.failOnIssues) {
                this.getLog().error((CharSequence)issue.toString());
                continue;
            }
            this.getLog().warn((CharSequence)issue.toString());
        }
        if (this.failOnIssues && !issues.isEmpty()) {
            throw new MojoExecutionException("Issues found in project.");
        }
        if (latestModificationTime > modifiedSinceTime) {
            try {
                this.getWorkFolder().mkdirs();
                if (!lastModifiedFile.exists()) {
                    lastModifiedFile.createNewFile();
                }
                lastModifiedFile.setLastModified(latestModificationTime);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write to working folder.", (Exception)e);
            }
        }
    }

    protected String[] getDefaultExcludes() {
        return new String[0];
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/*.js"};
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public JSLint getJsLint() {
        return this.jsLint;
    }

    public Integer getMaximumLengthOfLine() {
        return this.maximumLengthOfLine;
    }

    public Integer getMaximumNumberOfErrors() {
        return this.maximumNumberOfErrors;
    }

    private String[] getPathsOfJsFiles(final long modifiedSince) {
        final File sourceFolder = this.getSourceJsFolder();
        FilteredDirectoryScanner scanner = new FilteredDirectoryScanner(new FilteredDirectoryScanner.Filter(){

            public boolean apply(String pathname) {
                File sourceFile = new File(sourceFolder, pathname);
                long lastModified = sourceFile.lastModified();
                return lastModified > modifiedSince;
            }
        });
        scanner.setBasedir(sourceFolder);
        String[] includesArray = this.getPatternsOrDefault(this.includes, this.getDefaultIncludes());
        scanner.setIncludes(includesArray);
        String[] excludesArray = this.getPatternsOrDefault(this.excludes, this.getDefaultExcludes());
        scanner.setExcludes(excludesArray);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String[] getPatternsOrDefault(List<String> patterns, String[] defaultPatterns) {
        if (patterns == null || patterns.isEmpty()) {
            return defaultPatterns;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String getPredefinedVars() {
        return this.predefinedVars;
    }

    protected abstract File getSourceJsFolder();

    public int getStrictWhiteSpaceIndentation() {
        return this.strictWhiteSpaceIndentation;
    }

    protected abstract File getWorkFolder();

    protected void initJSLint() throws MojoExecutionException {
        this.jsLint = new JSLintBuilder().fromDefault();
        if (this.adsafe) {
            this.jsLint.addOption(Option.ADSAFE);
        }
        if (this.disallowBitwiseOperators) {
            this.jsLint.addOption(Option.BITWISE);
        }
        if (this.assumeABrowser) {
            this.jsLint.addOption(Option.BROWSER);
        }
        if (this.tolerateHTMLCase) {
            this.jsLint.addOption(Option.CAP);
        }
        if (this.tolerateContinuation) {
            this.jsLint.addOption(Option.CONTINUE);
        }
        if (this.tolerateCSSWorkarounds) {
            this.jsLint.addOption(Option.CSS);
        }
        if (this.tolerateDebuggerStatements) {
            this.jsLint.addOption(Option.DEBUG);
        }
        if (this.assumeConsoleAlertEtc) {
            this.jsLint.addOption(Option.DEVEL);
        }
        if (this.tolerateES5Syntax) {
            this.jsLint.addOption(Option.ES5);
        }
        if (this.tolerateEval) {
            this.jsLint.addOption(Option.EVIL);
        }
        if (this.tolerateUnfilteredForIn) {
            this.jsLint.addOption(Option.FORIN);
        }
        if (this.tolerateHTMLFragments) {
            this.jsLint.addOption(Option.FRAGMENT);
        }
        this.jsLint.addOption(Option.MAXERR, this.maximumNumberOfErrors.toString());
        if (this.maximumLengthOfLine != null) {
            this.jsLint.addOption(Option.MAXLEN, this.maximumLengthOfLine.toString());
        }
        if (this.requireInitialCapsForConstructors) {
            this.jsLint.addOption(Option.NEWCAP);
        }
        if (this.disallowDanglingUnderbarInIdentifiers) {
            this.jsLint.addOption(Option.NOMEN);
        }
        if (this.tolerateHTMLEventHandlers) {
            this.jsLint.addOption(Option.ON);
        }
        if (this.allowOneVarStatementPerFunction) {
            this.jsLint.addOption(Option.ONEVAR);
        }
        if (this.stopOnFirstError) {
            this.jsLint.addOption(Option.PASSFAIL);
        }
        if (this.disallowIncrAndDecr) {
            this.jsLint.addOption(Option.PLUSPLUS);
        }
        this.jsLint.addOption(Option.PREDEF, this.predefinedVars);
        if (this.disallowInsecureCharsInRegExp) {
            this.jsLint.addOption(Option.REGEXP);
        }
        if (this.assumeRhino) {
            this.jsLint.addOption(Option.RHINO);
        }
        if (this.safeSubset) {
            this.jsLint.addOption(Option.SAFE);
        }
        if (this.requireUseStrict) {
            this.jsLint.addOption(Option.STRICT);
        }
        if (this.tolerateInefficientSubscripting) {
            this.jsLint.addOption(Option.SUB);
        }
        if (this.disallowUndefinedVariables) {
            this.jsLint.addOption(Option.UNDEF);
        }
        if (this.strictWhiteSpace) {
            this.jsLint.addOption(Option.WHITE);
            this.jsLint.addOption(Option.INDENT, this.strictWhiteSpaceIndentation.toString());
        }
        if (this.assumeAYahooWidget) {
            this.jsLint.addOption(Option.WIDGET);
        }
        if (this.assumeWindows) {
            this.jsLint.addOption(Option.WINDOWS);
        }
    }

    public boolean isADsafe() {
        return this.adsafe;
    }

    public boolean isAllowOneVarStatementPerFunction() {
        return this.allowOneVarStatementPerFunction;
    }

    public boolean isAssumeABrowser() {
        return this.assumeABrowser;
    }

    public boolean isAssumeAYahooWidget() {
        return this.assumeAYahooWidget;
    }

    public boolean isAssumeConsoleAlertEtc() {
        return this.assumeConsoleAlertEtc;
    }

    public boolean isAssumeRhino() {
        return this.assumeRhino;
    }

    public boolean isAssumeWindows() {
        return this.assumeWindows;
    }

    public boolean isDisallowBitwiseOperators() {
        return this.disallowBitwiseOperators;
    }

    public boolean isDisallowDanglingUnderbarInIdentifiers() {
        return this.disallowDanglingUnderbarInIdentifiers;
    }

    public boolean isDisallowIncrAndDecr() {
        return this.disallowIncrAndDecr;
    }

    public boolean isDisallowInsecureCharsInRegExp() {
        return this.disallowInsecureCharsInRegExp;
    }

    public boolean isDisallowUndefinedVariables() {
        return this.disallowUndefinedVariables;
    }

    public boolean isFailOnIssues() {
        return this.failOnIssues;
    }

    public boolean isRequireInitialCapsForConstructors() {
        return this.requireInitialCapsForConstructors;
    }

    public boolean isRequireUseStrict() {
        return this.requireUseStrict;
    }

    public boolean isSafeSubset() {
        return this.safeSubset;
    }

    public boolean isStopOnFirstError() {
        return this.stopOnFirstError;
    }

    public boolean isStrictWhiteSpace() {
        return this.strictWhiteSpace;
    }

    public boolean isTolerateContinuation() {
        return this.tolerateContinuation;
    }

    public boolean isTolerateCSSWorkarounds() {
        return this.tolerateCSSWorkarounds;
    }

    public boolean isTolerateDebuggerStatements() {
        return this.tolerateDebuggerStatements;
    }

    public boolean isTolerateES5Syntax() {
        return this.tolerateES5Syntax;
    }

    public boolean isTolerateEval() {
        return this.tolerateEval;
    }

    public boolean isTolerateHTMLCase() {
        return this.tolerateHTMLCase;
    }

    public boolean isTolerateHTMLEventHandlers() {
        return this.tolerateHTMLEventHandlers;
    }

    public boolean isTolerateHTMLFragments() {
        return this.tolerateHTMLFragments;
    }

    public boolean isTolerateInefficientSubscripting() {
        return this.tolerateInefficientSubscripting;
    }

    public boolean isTolerateUnfilteredForIn() {
        return this.tolerateUnfilteredForIn;
    }

    public void setADsafe(boolean aDsafe) {
        this.adsafe = aDsafe;
    }

    public void setAllowOneVarStatementPerFunction(boolean allowOneVarStatementPerFunction) {
        this.allowOneVarStatementPerFunction = allowOneVarStatementPerFunction;
    }

    public void setAssumeABrowser(boolean assumeABrowser) {
        this.assumeABrowser = assumeABrowser;
    }

    public void setAssumeAYahooWidget(boolean assumeAYahooWidget) {
        this.assumeAYahooWidget = assumeAYahooWidget;
    }

    public void setAssumeConsoleAlertEtc(boolean assumeConsoleAlertEtc) {
        this.assumeConsoleAlertEtc = assumeConsoleAlertEtc;
    }

    public void setAssumeRhino(boolean assumeRhino) {
        this.assumeRhino = assumeRhino;
    }

    public void setAssumeWindows(boolean assumeWindows) {
        this.assumeWindows = assumeWindows;
    }

    public void setDisallowBitwiseOperators(boolean disallowBitwiseOperators) {
        this.disallowBitwiseOperators = disallowBitwiseOperators;
    }

    public void setDisallowDanglingUnderbarInIdentifiers(boolean disallowDanglingUnderbarInIdentifiers) {
        this.disallowDanglingUnderbarInIdentifiers = disallowDanglingUnderbarInIdentifiers;
    }

    public void setDisallowIncrAndDecr(boolean disallowIncrAndDecr) {
        this.disallowIncrAndDecr = disallowIncrAndDecr;
    }

    public void setDisallowInsecureCharsInRegExp(boolean disallowInsecureCharsInRegExp) {
        this.disallowInsecureCharsInRegExp = disallowInsecureCharsInRegExp;
    }

    public void setDisallowUndefinedVariables(boolean disallowUndefinedVariables) {
        this.disallowUndefinedVariables = disallowUndefinedVariables;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setFailOnIssues(boolean failOnIssues) {
        this.failOnIssues = failOnIssues;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setMaximumLengthOfLine(Integer maximumLengthOfLine) {
        this.maximumLengthOfLine = maximumLengthOfLine;
    }

    public void setMaximumNumberOfErrors(Integer maximumNumberOfErrors) {
        this.maximumNumberOfErrors = maximumNumberOfErrors;
    }

    public void setPredefinedVars(String predefinedVars) {
        this.predefinedVars = predefinedVars;
    }

    public void setRequireInitialCapsForConstructors(boolean requireInitialCapsForConstructors) {
        this.requireInitialCapsForConstructors = requireInitialCapsForConstructors;
    }

    public void setRequireUseStrict(boolean requireUseStrict) {
        this.requireUseStrict = requireUseStrict;
    }

    public void setSafeSubset(boolean safeSubset) {
        this.safeSubset = safeSubset;
    }

    protected abstract void setSourceJsFolder(File var1);

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.stopOnFirstError = stopOnFirstError;
    }

    public void setStrictWhiteSpace(boolean strictWhiteSpace) {
        this.strictWhiteSpace = strictWhiteSpace;
    }

    public void setStrictWhiteSpaceIndentation(Integer strictWhiteSpaceIndentation) {
        this.strictWhiteSpaceIndentation = strictWhiteSpaceIndentation;
    }

    public void setTolerateContinuation(boolean tolerateContinuation) {
        this.tolerateContinuation = tolerateContinuation;
    }

    public void setTolerateCSSWorkarounds(boolean tolerateCSSWorkarounds) {
        this.tolerateCSSWorkarounds = tolerateCSSWorkarounds;
    }

    public void setTolerateDebuggerStatements(boolean tolerateDebuggerStatements) {
        this.tolerateDebuggerStatements = tolerateDebuggerStatements;
    }

    public void setTolerateES5Syntax(boolean tolerateES5Syntax) {
        this.tolerateES5Syntax = tolerateES5Syntax;
    }

    public void setTolerateEval(boolean tolerateEval) {
        this.tolerateEval = tolerateEval;
    }

    public void setTolerateHTMLCase(boolean tolerateHTMLCase) {
        this.tolerateHTMLCase = tolerateHTMLCase;
    }

    public void setTolerateHTMLEventHandlers(boolean tolerateHTMLEventHandlers) {
        this.tolerateHTMLEventHandlers = tolerateHTMLEventHandlers;
    }

    public void setTolerateHTMLFragments(boolean tolerateHTMLFragments) {
        this.tolerateHTMLFragments = tolerateHTMLFragments;
    }

    public void setTolerateInefficientSubscripting(boolean tolerateInefficientSubscripting) {
        this.tolerateInefficientSubscripting = tolerateInefficientSubscripting;
    }

    public void setTolerateUnfilteredForIn(boolean tolerateUnfilteredForIn) {
        this.tolerateUnfilteredForIn = tolerateUnfilteredForIn;
    }

    protected abstract void setWorkFolder(File var1);
}

