/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.AbstractLicensesXmlMojo;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.LicenseSummaryReader;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.FileUtil;

@Mojo(name="licenses-xml-insert-versions", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class LicensesXmlInsertVersionsMojo
extends AbstractLicensesXmlMojo {
    @Parameter(property="license.licensesInputFile")
    protected File licensesInputFile;
    @Parameter(property="license.skipDownloadLicenses", defaultValue="false")
    private boolean skipDownloadLicenses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipDownloadLicenses) {
            this.getLog().info((CharSequence)"Skipping due to skipDownloadLicenses = true");
            return;
        }
        if (this.licensesInputFile == null) {
            this.licensesInputFile = this.licensesOutputFile;
        }
        try {
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
            List<ProjectLicenseInfo> projectLicenseInfos = LicenseSummaryReader.parseLicenseSummary(this.licensesInputFile);
            if (projectLicenseInfos.isEmpty() && this.licensesInputFile.equals(this.licensesOutputFile)) {
                this.getLog().info((CharSequence)("Nothing to do. The licensesInputFile \"" + this.licensesInputFile + "\" is either empty or does not exist."));
                return;
            }
            ArtifactFilters.Builder artifactFiltersBuilder = ArtifactFilters.buidler();
            for (ProjectLicenseInfo dep : projectLicenseInfos) {
                artifactFiltersBuilder.includeGa("\\Q" + dep.getGroupId() + ":" + dep.getArtifactId() + "\\E");
            }
            final ArtifactFilters artifactFilters = artifactFiltersBuilder.build();
            MavenProjectDependenciesConfigurator config = new MavenProjectDependenciesConfigurator(){

                @Override
                public boolean isVerbose() {
                    return LicensesXmlInsertVersionsMojo.this.getLog().isDebugEnabled();
                }

                @Override
                public boolean isIncludeTransitiveDependencies() {
                    return true;
                }

                @Override
                public boolean isExcludeTransitiveDependencies() {
                    return false;
                }

                @Override
                public ArtifactFilters getArtifactFilters() {
                    return artifactFilters;
                }
            };
            Collection<MavenProject> resolvedDeps = this.dependenciesTool.loadProjectDependencies(new ResolvedProjectDependencies(this.project.getArtifacts(), this.project.getDependencyArtifacts()), config, this.localRepository, this.remoteRepositories, null).values();
            HashMap<String, MavenProject> resolvedDepsMap = new HashMap<String, MavenProject>(resolvedDeps.size());
            for (MavenProject dep : resolvedDeps) {
                resolvedDepsMap.put(dep.getGroupId() + ":" + dep.getArtifactId(), dep);
            }
            for (ProjectLicenseInfo dependencyLicenseInfo : projectLicenseInfos) {
                this.getLog().debug((CharSequence)("Checking licenses for project " + dependencyLicenseInfo.toString()));
                String id = dependencyLicenseInfo.getId();
                MavenProject dependency = (MavenProject)resolvedDepsMap.get(id);
                if (dependency == null) {
                    throw new MojoFailureException("Could not resolve version of " + id + " in file " + this.licensesOutputFile);
                }
                dependencyLicenseInfo.setVersion(dependency.getVersion());
            }
            this.writeLicenseSummary(projectLicenseInfos, this.licensesOutputFile, true);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
        }
    }

    @Override
    protected Path[] getAutodetectEolFiles() {
        return new Path[]{this.licensesInputFile.toPath(), this.licensesOutputFile.toPath()};
    }
}

