/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.license.download.FileNameEntry;
import org.codehaus.mojo.license.spdx.SpdxLicenseInfo;
import org.codehaus.mojo.license.spdx.SpdxLicenseList;
import org.codehaus.mojo.license.utils.FileUtil;

public class PreferredFileNames {
    private final File licensesOutputDirectory;
    private final Map<String, Map.Entry<String, List<Pattern>>> fileNameToUrlPatterns;
    private final Map<String, String> sha1ToFileName;
    private final Log log;

    public static PreferredFileNames build(File licensesOutputDirectory, Map<String, String> licenseUrlFileNames, Log log) {
        LinkedHashMap<String, Map.Entry<String, List<Pattern>>> fileNameToUrlPatterns = new LinkedHashMap<String, Map.Entry<String, List<Pattern>>>();
        LinkedHashMap<String, String> sha1TofileName = new LinkedHashMap<String, String>();
        if (licenseUrlFileNames != null) {
            if (licenseUrlFileNames.containsKey("spdx")) {
                PreferredFileNames.spdx(log, fileNameToUrlPatterns, sha1TofileName);
            }
            for (Map.Entry<String, String> en : licenseUrlFileNames.entrySet()) {
                String[] rawPatters;
                String fileName = en.getKey();
                if (fileName == null || fileName.isEmpty() || "spdx".equals(fileName) || en.getValue() == null || (rawPatters = en.getValue().split("\\s+")) == null) continue;
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                String sha1 = null;
                for (String rawPattern : rawPatters) {
                    if (rawPattern.startsWith("sha1:")) {
                        if (sha1 != null) {
                            throw new IllegalStateException("sha1 defined twice for licenseFileName '" + fileName + "'");
                        }
                        sha1 = rawPattern.substring(5);
                        continue;
                    }
                    patterns.add(Pattern.compile(rawPattern, 2));
                }
                if (sha1 != null) {
                    sha1TofileName.put(sha1, fileName);
                }
                fileNameToUrlPatterns.put(fileName, new AbstractMap.SimpleImmutableEntry(sha1, Collections.unmodifiableList(patterns)));
            }
        }
        return new PreferredFileNames(licensesOutputDirectory, fileNameToUrlPatterns, sha1TofileName, log);
    }

    private static <V, K> void spdx(Log log, Map<String, Map.Entry<String, List<Pattern>>> result, Map<String, String> sha1TofileName) {
        TreeMap fileNameToUrlPatterns = new TreeMap();
        SpdxLicenseList spdxList = SpdxLicenseList.getLatest();
        Map<String, SpdxLicenseInfo> lics = spdxList.getLicenses();
        log.info((CharSequence)("Honoring " + lics.size() + " SPDX licenses"));
        HashMap<Object, TreeSet<String>> sha1ToLicenseIds = new HashMap<Object, TreeSet<String>>();
        HashMap<Object, TreeSet<String>> sha1ToUrls = new HashMap<Object, TreeSet<String>>();
        HashSet<Object> stableSha1s = new HashSet<Object>();
        for (SpdxLicenseInfo spdxLicenseInfo : lics.values()) {
            if (spdxLicenseInfo.isDeprecatedLicenseId()) continue;
            for (Map.Entry<String, SpdxLicenseInfo.Attachments.UrlInfo> urlInfoEntry : spdxLicenseInfo.getAttachments().getUrlInfos().entrySet()) {
                TreeSet<String> licIds;
                SpdxLicenseInfo.Attachments.UrlInfo urlInfo = urlInfoEntry.getValue();
                if (urlInfo.getSha1() == null || urlInfo.getMimeType() == null) continue;
                String sha1 = urlInfo.getSha1();
                if (urlInfo.isStable()) {
                    stableSha1s.add(sha1);
                }
                if ((licIds = (TreeSet<String>)sha1ToLicenseIds.get(sha1)) == null) {
                    licIds = new TreeSet<String>();
                    sha1ToLicenseIds.put(sha1, licIds);
                }
                licIds.add(spdxLicenseInfo.getLicenseId());
                TreeSet<String> urls = (TreeSet<String>)sha1ToUrls.get(sha1);
                if (urls == null) {
                    urls = new TreeSet<String>();
                    sha1ToUrls.put(sha1, urls);
                }
                urls.add(urlInfoEntry.getKey());
            }
        }
        for (Map.Entry entry : sha1ToLicenseIds.entrySet()) {
            Set licIds = (Set)entry.getValue();
            StringBuilder baseNameBuilder = new StringBuilder();
            HashMap<String, LinkedHashSet<String>> mimeTypeToSha1 = new HashMap<String, LinkedHashSet<String>>();
            for (String licId : licIds) {
                if (baseNameBuilder.length() > 0) {
                    baseNameBuilder.append("-OR-");
                }
                baseNameBuilder.append(licId);
                SpdxLicenseInfo lic = lics.get(licId);
                for (Map.Entry<String, SpdxLicenseInfo.Attachments.UrlInfo> urlInfoEntry : lic.getAttachments().getUrlInfos().entrySet()) {
                    SpdxLicenseInfo.Attachments.UrlInfo urlInfo = urlInfoEntry.getValue();
                    String mimeType = urlInfo.getMimeType();
                    if (!sha1ToLicenseIds.containsKey(urlInfo.getSha1()) || mimeType == null) continue;
                    LinkedHashSet<String> sha1s = (LinkedHashSet<String>)mimeTypeToSha1.get(mimeType);
                    if (sha1s == null) {
                        sha1s = new LinkedHashSet<String>();
                        mimeTypeToSha1.put(mimeType, sha1s);
                    }
                    sha1s.add(urlInfo.getSha1());
                }
            }
            String baseName = baseNameBuilder.toString();
            for (Map.Entry mimeTypeSha1 : mimeTypeToSha1.entrySet()) {
                String mimeType = (String)mimeTypeSha1.getKey();
                if (mimeType == null) {
                    throw new IllegalStateException("mimeType must not be null");
                }
                Set sha1s = (Set)mimeTypeSha1.getValue();
                for (String sha1 : sha1s) {
                    String useSha1;
                    String uniqueName = sha1s.size() == 1 ? baseName : baseName + "-" + sha1.substring(0, 7);
                    String fileName = uniqueName + FileUtil.toExtension(mimeType, true);
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    Set urls = (Set)sha1ToUrls.get(sha1);
                    for (String url : urls) {
                        patterns.add(Pattern.compile(Pattern.quote(url), 2));
                    }
                    String string = useSha1 = stableSha1s.contains(sha1) ? sha1 : null;
                    if (useSha1 != null) {
                        sha1TofileName.put(useSha1, fileName);
                    }
                    List<Pattern> usePatterns = Collections.unmodifiableList(patterns);
                    Map.Entry avail = (Map.Entry)fileNameToUrlPatterns.get(fileName);
                    if (avail == null) {
                        fileNameToUrlPatterns.put(fileName, new AbstractMap.SimpleImmutableEntry(useSha1, usePatterns));
                        continue;
                    }
                    if ((avail.getKey() == useSha1 || avail.getKey() != null && ((String)avail.getKey()).equals(useSha1)) && PreferredFileNames.isEqual(usePatterns, (List)avail.getValue())) continue;
                    log.warn((CharSequence)("Available: " + fileName + ", " + (String)avail.getKey() + ", " + avail.getValue()));
                    log.warn((CharSequence)("To add   : " + fileName + ", " + useSha1 + ", " + patterns));
                    throw new IllegalStateException(fileName + " already present");
                }
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<licenseUrlFileNames>\n");
            for (Map.Entry en : fileNameToUrlPatterns.entrySet()) {
                String fileName = (String)en.getKey();
                String sha1 = (String)((Map.Entry)en.getValue()).getKey();
                List patterns = (List)((Map.Entry)en.getValue()).getValue();
                sb.append("  <" + fileName + ">\n");
                if (sha1 != null) {
                    sb.append("    sha1:" + sha1 + "\n");
                }
                for (Pattern pattern : patterns) {
                    sb.append("    " + pattern.pattern() + "\n");
                }
                sb.append("  </" + fileName + ">\n");
            }
            sb.append("</licenseUrlFileNames>\n");
            log.debug((CharSequence)"SPDX licenseUrlFileNames:");
            log.debug((CharSequence)sb.toString());
        }
        result.putAll(fileNameToUrlPatterns);
    }

    private static boolean isEqual(List<Pattern> newPatterns, List<Pattern> oldPatterns) {
        if (oldPatterns.size() != newPatterns.size()) {
            return false;
        }
        Iterator<Pattern> newIt = newPatterns.iterator();
        Iterator<Pattern> oldIt = oldPatterns.iterator();
        while (newIt.hasNext()) {
            if (newIt.next().pattern().equals(oldIt.next().pattern())) continue;
            return false;
        }
        return true;
    }

    public PreferredFileNames(File licensesOutputDirectory, Map<String, Map.Entry<String, List<Pattern>>> fileNameToUrlPatterns, Map<String, String> sha1ToFileName, Log log) {
        this.licensesOutputDirectory = licensesOutputDirectory;
        this.fileNameToUrlPatterns = fileNameToUrlPatterns;
        this.sha1ToFileName = sha1ToFileName;
        this.log = log;
    }

    public String getFileNameBySha1(String sha1) {
        return this.sha1ToFileName.get(sha1);
    }

    public FileNameEntry getEntryByUrl(String url) {
        for (Map.Entry<String, Map.Entry<String, List<Pattern>>> fn : this.fileNameToUrlPatterns.entrySet()) {
            for (Pattern pat : fn.getValue().getValue()) {
                if (!pat.matcher(url).matches()) continue;
                this.log.debug((CharSequence)("Using file name '" + fn.getKey() + "' for URL '" + url + "' that matched pattern '" + pat.pattern() + "'"));
                return new FileNameEntry(new File(this.licensesOutputDirectory, fn.getKey()), true, fn.getValue().getKey());
            }
        }
        return null;
    }
}

