/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedProperties
extends Properties {
    private static final long serialVersionUID = -1147150444452577558L;
    protected String encoding;
    protected boolean removeHeader;

    public SortedProperties(String encoding) {
        this(encoding, true);
    }

    public SortedProperties(String encoding, boolean removeHeader) {
        this.encoding = encoding;
        this.removeHeader = removeHeader;
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public Enumeration<Object> keys() {
        Vector<Object> result;
        ArrayList<Object> objects = Collections.list(super.keys());
        try {
            List<String> list = SortedProperties.toGenericList(objects, String.class);
            Collections.sort(list);
            result = new Vector<String>(list);
        }
        catch (IllegalArgumentException e) {
            result = new Vector<Object>(objects);
        }
        return result.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedProperties load(File src) throws IOException {
        FileInputStream reader = new FileInputStream(src);
        try {
            this.load(reader);
        }
        finally {
            reader.close();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File dst) throws IOException {
        FileOutputStream writer = new FileOutputStream(dst);
        try {
            this.store(writer, null);
        }
        finally {
            ((OutputStream)writer).close();
        }
    }

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }
}

