/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.codehaus.mojo.license.utils.UrlRequester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseMojoUtils {
    private static final LoggerFacade LOG = new Slf4jLoggerFacade(LoggerFactory.getLogger(LicenseMojoUtils.class));
    static final String NO_URL = "file:///inexistent";
    static final String DEFAULT_OVERRIDE_THIRD_PARTY = "src/license/override-THIRD-PARTY.properties";

    private LicenseMojoUtils() {
    }

    public static boolean isValid(String url) {
        return url != null && !NO_URL.equals(url);
    }

    public static String prepareThirdPartyOverrideUrl(String resolvedUrl, File deprecatedFile, String url, File basedir) {
        return LicenseMojoUtils.prepareThirdPartyOverrideUrl(resolvedUrl, deprecatedFile, url, basedir, LOG);
    }

    static String prepareThirdPartyOverrideUrl(String resolvedUrl, File deprecatedFile, String url, File basedir, LoggerFacade log) {
        if (deprecatedFile != null) {
            log.warn("'overrideFile' mojo parameter is deprecated. Use 'overrideUrl' instead.");
        }
        return LicenseMojoUtils.prepareUrl(resolvedUrl, deprecatedFile, url, basedir, DEFAULT_OVERRIDE_THIRD_PARTY, log);
    }

    private static String prepareUrl(String resolvedUrl, File deprecatedFile, String url, File basedir, String defaultFilePath, LoggerFacade log) {
        Path basedirPath;
        Path defaultPath;
        if (resolvedUrl != null && !NO_URL.equals(resolvedUrl)) {
            return resolvedUrl;
        }
        if (deprecatedFile != null && url != null && !url.isEmpty()) {
            throw new IllegalArgumentException("You can't use both overrideFile and overrideUrl");
        }
        if (deprecatedFile != null) {
            if (deprecatedFile.exists()) {
                String result = deprecatedFile.toURI().toString();
                log.debug("Loading overrides from file {}", result);
                return result;
            }
            log.warn("overrideFile [{}] was configured but doesn't exist", deprecatedFile.getAbsolutePath());
        }
        if (url != null) {
            if (UrlRequester.isStringUrl(url)) {
                log.debug("Loading overrides from URL {}", url);
                return url;
            }
            log.warn("Unsupported or invalid URL [{}] found in overrideUrl; supported are 'classpath:' URLs and  anything your JVM supports (file:, http: and https: should always work)", url);
        }
        if (Files.exists(defaultPath = (basedirPath = basedir.toPath()).resolve(defaultFilePath), new LinkOption[0])) {
            String result = defaultPath.toUri().toString();
            log.debug("Loading overrides from file {}", result);
            return result;
        }
        log.debug("No (valid) URL and no file [{}] found; not loading any overrides", defaultPath.toAbsolutePath());
        return NO_URL;
    }

    static interface LoggerFacade {
        public void warn(String var1);

        public void warn(String var1, Object var2);

        public void debug(String var1, Object var2);
    }

    static class Slf4jLoggerFacade
    implements LoggerFacade {
        private final Logger delegate;

        public Slf4jLoggerFacade(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public void warn(String message) {
            this.delegate.warn(message);
        }

        @Override
        public void warn(String template, Object param) {
            this.delegate.warn(template, param);
        }

        @Override
        public void debug(String template, Object param) {
            this.delegate.debug(template, param);
        }
    }
}

